/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.gateway.security;

import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.linkis.common.conf.Configuration$;
import org.apache.linkis.common.exception.LinkisException;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.gateway.config.GatewayConfiguration$;
import org.apache.linkis.gateway.http.GatewayContext;
import org.apache.linkis.gateway.http.GatewayHttpResponse;
import org.apache.linkis.gateway.security.GatewaySSOUtils$;
import org.apache.linkis.gateway.security.UserRestful;
import org.apache.linkis.gateway.security.sso.SSOInterceptor$;
import org.apache.linkis.gateway.security.token.TokenAuthentication$;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.Message$;
import org.apache.linkis.server.conf.ServerConfiguration$;
import org.apache.linkis.server.exception.LoginExpireException;
import org.apache.linkis.server.exception.NonLoginException;
import org.apache.linkis.server.package$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

public final class SecurityFilter$
implements Logging {
    public static final SecurityFilter$ MODULE$;
    private final boolean refererValidate;
    private final String referers;
    private final String testUser;
    private final HashSet<String> org$apache$linkis$gateway$security$SecurityFilter$$ipSet;
    private UserRestful org$apache$linkis$gateway$security$SecurityFilter$$userRestful;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SecurityFilter$();
    }

    private Logger logger$lzycompute() {
        SecurityFilter$ securityFilter$ = this;
        synchronized (securityFilter$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    private boolean refererValidate() {
        return this.refererValidate;
    }

    private String referers() {
        return this.referers;
    }

    public String testUser() {
        return this.testUser;
    }

    public HashSet<String> org$apache$linkis$gateway$security$SecurityFilter$$ipSet() {
        return this.org$apache$linkis$gateway$security$SecurityFilter$$ipSet;
    }

    public boolean doFilter(GatewayContext gatewayContext) {
        NonLocalReturnControl nonLocalReturnControl2;
        block27: {
            boolean bl;
            Object object = new Object();
            try {
                this.addAccessHeaders(gatewayContext);
                if (BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.ENABLE_GATEWAY_AUTH().getValue())) {
                    String host = gatewayContext.getRequest().getRemoteAddress().getAddress().toString().replaceAll("/", "");
                    int port = gatewayContext.getRequest().getRemoteAddress().getPort();
                    if (!this.org$apache$linkis$gateway$security$SecurityFilter$$ipSet().contains(host)) {
                        this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " and ", " is not in whitelist, it is dangerous"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{host, BoxesRunTime.boxToInteger((int)port)})));
                        this.filterResponse(gatewayContext, Message$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not in whitelist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{host}))));
                        return false;
                    }
                }
                gatewayContext.getRequest().getURI().getHost();
                if (this.refererValidate()) {
                    String[] referer = gatewayContext.getRequest().getHeaders().get("Referer");
                    String[] refList = StringUtils.isNotEmpty((String)this.referers()) ? this.referers().split(",") : (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.Nothing());
                    boolean flag = Predef$.MODULE$.refArrayOps((Object[])refList).exists((Function1)new Serializable(referer){
                        public static final long serialVersionUID = 0L;
                        private final String[] referer$1;

                        public final boolean apply(String ref) {
                            return this.referer$1 != null && Predef$.MODULE$.refArrayOps((Object[])this.referer$1).nonEmpty() && StringUtils.isNotEmpty((String)((String)Predef$.MODULE$.refArrayOps((Object[])this.referer$1).head())) && ((String)Predef$.MODULE$.refArrayOps((Object[])this.referer$1).head()).trim().contains(ref);
                        }
                        {
                            this.referer$1 = referer$1;
                        }
                    });
                    if (referer != null && Predef$.MODULE$.refArrayOps((Object[])referer).nonEmpty() && StringUtils.isNotEmpty((String)((String)Predef$.MODULE$.refArrayOps((Object[])referer).head())) && !flag) {
                        this.filterResponse(gatewayContext, package$.MODULE$.validateFailed("Unallowed cross-site request(\u4e0d\u5141\u8bb8\u7684\u8de8\u7ad9\u8bf7\u6c42)\uff01"));
                        return false;
                    }
                    if (!gatewayContext.isWebSocketRequest() && (referer == null || Predef$.MODULE$.refArrayOps((Object[])referer).isEmpty() || StringUtils.isEmpty((String)((String)Predef$.MODULE$.refArrayOps((Object[])referer).head())))) {
                        this.filterResponse(gatewayContext, package$.MODULE$.validateFailed("referer\u4e3a\u7a7a,\u4e0d\u80fd\u7ee7\u7eed\u8bbf\u95ee"));
                        return false;
                    }
                    String string = gatewayContext.getRequest().getMethod().toUpperCase();
                    boolean bl2 = "GET".equals(string) ? true : ("POST".equals(string) ? true : ("PUT".equals(string) ? true : ("DELETE".equals(string) ? true : ("HEAD".equals(string) ? true : ("TRACE".equals(string) ? true : ("CONNECT".equals(string) ? true : "OPTIONS".equals(string)))))));
                    if (bl2) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.filterResponse(gatewayContext, package$.MODULE$.validateFailed("Do not use HTTP verbs to tamper with(\u4e0d\u53ef\u4f7f\u7528HTTP\u52a8\u8bcd\u7be1\u6539)\uff01"));
                        return false;
                    }
                }
                boolean isPassAuthRequest = Predef$.MODULE$.refArrayOps((Object[])GatewayConfiguration$.MODULE$.PASS_AUTH_REQUEST_URI()).exists((Function1)new Serializable(gatewayContext){
                    public static final long serialVersionUID = 0L;
                    private final GatewayContext gatewayContext$1;

                    public final boolean apply(String r) {
                        return !r.equals("") && this.gatewayContext$1.getRequest().getRequestURI().startsWith(r);
                    }
                    {
                        this.gatewayContext$1 = gatewayContext$1;
                    }
                });
                if (gatewayContext.getRequest().getRequestURI().startsWith((String)ServerConfiguration$.MODULE$.BDP_SERVER_USER_URI().getValue())) {
                    Utils$.MODULE$.tryCatch((Function0)new Serializable(gatewayContext){
                        public static final long serialVersionUID = 0L;
                        private final GatewayContext gatewayContext$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            SecurityFilter$.MODULE$.org$apache$linkis$gateway$security$SecurityFilter$$userRestful().doUserRequest(this.gatewayContext$1);
                        }
                        {
                            this.gatewayContext$1 = gatewayContext$1;
                        }
                    }, (Function1)new Serializable(gatewayContext){
                        public static final long serialVersionUID = 0L;
                        private final GatewayContext gatewayContext$1;

                        public final void apply(Throwable t) {
                            String string;
                            Throwable throwable = t;
                            if (throwable instanceof LinkisException) {
                                LinkisException linkisException = (LinkisException)throwable;
                                string = linkisException.getMessage();
                            } else {
                                string = new StringBuilder().append((Object)"login failed! reason: ").append((Object)ExceptionUtils.getRootCauseMessage((Throwable)t)).toString();
                            }
                            String message = string;
                            GatewaySSOUtils$.MODULE$.error((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "login failed!";
                                }
                            }, t);
                            SecurityFilter$.MODULE$.filterResponse(this.gatewayContext$1, Message$.MODULE$.error(message).$less$less(this.gatewayContext$1.getRequest().getRequestURI()));
                        }
                        {
                            this.gatewayContext$1 = gatewayContext$1;
                        }
                    });
                    bl = false;
                } else if (isPassAuthRequest && !BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.ENABLE_SSO_LOGIN().getValue())) {
                    GatewaySSOUtils$.MODULE$.info((Function0<String>)new Serializable(gatewayContext){
                        public static final long serialVersionUID = 0L;
                        private final GatewayContext gatewayContext$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"No login needed for proxy uri: ").append((Object)this.gatewayContext$1.getRequest().getRequestURI()).toString();
                        }
                        {
                            this.gatewayContext$1 = gatewayContext$1;
                        }
                    });
                    bl = true;
                } else if (TokenAuthentication$.MODULE$.isTokenRequest(gatewayContext)) {
                    bl = TokenAuthentication$.MODULE$.tokenAuth(gatewayContext);
                } else {
                    Option userName = (Option)Utils$.MODULE$.tryCatch((Function0)new Serializable(gatewayContext){
                        public static final long serialVersionUID = 0L;
                        private final GatewayContext gatewayContext$1;

                        public final Option<String> apply() {
                            return GatewaySSOUtils$.MODULE$.getLoginUser(this.gatewayContext$1);
                        }
                        {
                            this.gatewayContext$1 = gatewayContext$1;
                        }
                    }, (Function1)new Serializable(gatewayContext, object){
                        public static final long serialVersionUID = 0L;
                        private final GatewayContext gatewayContext$1;
                        private final Object nonLocalReturnKey1$1;

                        public final Option<String> apply(Throwable x0$1) {
                            Throwable throwable = x0$1;
                            boolean bl = throwable instanceof NonLoginException ? true : throwable instanceof LoginExpireException;
                            if (bl) {
                                if (BoxesRunTime.unboxToBoolean((Object)Configuration$.MODULE$.IS_TEST_MODE().getValue())) {
                                    None$ none$ = None$.MODULE$;
                                    return none$;
                                }
                                SecurityFilter$.MODULE$.filterResponse(this.gatewayContext$1, Message$.MODULE$.noLogin(throwable.getMessage()).$less$less(this.gatewayContext$1.getRequest().getRequestURI()));
                                throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, false);
                            }
                            if (throwable != null) {
                                Throwable throwable2 = throwable;
                                GatewaySSOUtils$.MODULE$.warn((Function0<String>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "";
                                    }
                                }, throwable2);
                                throw throwable2;
                            }
                            throw new MatchError((Object)throwable);
                        }
                        {
                            this.gatewayContext$1 = gatewayContext$1;
                            this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        }
                    });
                    if (userName.isDefined()) {
                        bl = true;
                    } else if (BoxesRunTime.unboxToBoolean((Object)Configuration$.MODULE$.IS_TEST_MODE().getValue())) {
                        GatewaySSOUtils$.MODULE$.info((Function0<String>)new Serializable(gatewayContext){
                            public static final long serialVersionUID = 0L;
                            private final GatewayContext gatewayContext$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"test mode! login for uri: ").append((Object)this.gatewayContext$1.getRequest().getRequestURI()).toString();
                            }
                            {
                                this.gatewayContext$1 = gatewayContext$1;
                            }
                        });
                        GatewaySSOUtils$.MODULE$.setLoginUser(gatewayContext, this.testUser());
                        bl = true;
                    } else if (BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.ENABLE_SSO_LOGIN().getValue())) {
                        String user = SSOInterceptor$.MODULE$.getSSOInterceptor().getUser(gatewayContext);
                        if (StringUtils.isNotBlank((String)user)) {
                            GatewaySSOUtils$.MODULE$.setLoginUser(gatewayContext.getRequest(), user);
                            bl = true;
                        } else if (isPassAuthRequest) {
                            gatewayContext.getResponse().redirectTo(SSOInterceptor$.MODULE$.getSSOInterceptor().redirectTo(gatewayContext.getRequest().getURI()));
                            gatewayContext.getResponse().sendResponse();
                            bl = false;
                        } else {
                            this.filterResponse(gatewayContext, Message$.MODULE$.noLogin("You are not logged in, please login first(\u60a8\u5c1a\u672a\u767b\u5f55\uff0c\u8bf7\u5148\u767b\u5f55)!").data("enableSSO", (Object)BoxesRunTime.boxToBoolean((boolean)true)).data("SSOURL", (Object)SSOInterceptor$.MODULE$.getSSOInterceptor().redirectTo(gatewayContext.getRequest().getURI())).$less$less(gatewayContext.getRequest().getRequestURI()));
                            bl = false;
                        }
                    } else if (gatewayContext.getRequest().getRequestURI().matches((String)GatewayConfiguration$.MODULE$.GATEWAY_NO_AUTH_URL_REGEX().getValue())) {
                        GatewaySSOUtils$.MODULE$.info((Function0<String>)new Serializable(gatewayContext){
                            public static final long serialVersionUID = 0L;
                            private final GatewayContext gatewayContext$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Not logged in, still let it pass (GATEWAY_NO_AUTH_URL): ").append((Object)this.gatewayContext$1.getRequest().getRequestURI()).toString();
                            }
                            {
                                this.gatewayContext$1 = gatewayContext$1;
                            }
                        });
                        bl = true;
                    } else {
                        this.filterResponse(gatewayContext, Message$.MODULE$.noLogin("You are not logged in, please login first(\u60a8\u5c1a\u672a\u767b\u5f55\uff0c\u8bf7\u5148\u767b\u5f55)!").$less$less(gatewayContext.getRequest().getRequestURI()));
                        bl = false;
                    }
                }
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block27;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public UserRestful org$apache$linkis$gateway$security$SecurityFilter$$userRestful() {
        return this.org$apache$linkis$gateway$security$SecurityFilter$$userRestful;
    }

    private void org$apache$linkis$gateway$security$SecurityFilter$$userRestful_$eq(UserRestful x$1) {
        this.org$apache$linkis$gateway$security$SecurityFilter$$userRestful = x$1;
    }

    public void setUserRestful(UserRestful userRestful) {
        this.org$apache$linkis$gateway$security$SecurityFilter$$userRestful_$eq(userRestful);
    }

    public void filterResponse(GatewayContext gatewayContext, Message message) {
        gatewayContext.getResponse().setStatus(Message$.MODULE$.messageToHttpStatus(message));
        gatewayContext.getResponse().write(Message$.MODULE$.response(message));
        gatewayContext.getResponse().sendResponse();
    }

    public void org$apache$linkis$gateway$security$SecurityFilter$$init() {
        Utils$.MODULE$.tryAndError((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File authFile = new File(SecurityFilter$.MODULE$.getClass().getClassLoader().getResource((String)GatewayConfiguration$.MODULE$.AUTH_IP_FILE().getValue()).toURI().getPath());
                BufferedSource source = Source$.MODULE$.fromFile(authFile, "UTF-8");
                String[] lines = (String[])source.getLines().toArray(ClassTag$.MODULE$.apply(String.class));
                Predef$.MODULE$.refArrayOps((Object[])lines).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$1) {
                        return SecurityFilter$.MODULE$.org$apache$linkis$gateway$security$SecurityFilter$$ipSet().add(x$1);
                    }
                });
            }
        }, this.logger());
    }

    public void addAccessHeaders(GatewayContext gatewayContext) {
        GatewayHttpResponse response = gatewayContext.getResponse();
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Access-Control-Allow-Headers", "authorization,Content-Type");
        response.setHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, HEAD, DELETE");
        DateFormat fullDateFormatEN = DateFormat.getDateTimeInstance(0, 0, new Locale("EN", "en"));
        response.setHeader("Date", fullDateFormatEN.format(new Date()));
    }

    private SecurityFilter$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.refererValidate = BoxesRunTime.unboxToBoolean((Object)ServerConfiguration$.MODULE$.BDP_SERVER_SECURITY_REFERER_VALIDATE().getValue());
        this.referers = (String)ServerConfiguration$.MODULE$.BDP_SERVER_ADDRESS().getValue();
        this.testUser = (String)ServerConfiguration$.MODULE$.BDP_TEST_USER().getValue();
        this.org$apache$linkis$gateway$security$SecurityFilter$$ipSet = new HashSet();
        Object object = BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.ENABLE_GATEWAY_AUTH().getValue()) ? Utils$.MODULE$.defaultScheduler().scheduleAtFixedRate(new Runnable(){

            public void run() {
                Utils$.MODULE$.tryAndError((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        SecurityFilter$.MODULE$.org$apache$linkis$gateway$security$SecurityFilter$$init();
                    }
                }, SecurityFilter$.MODULE$.logger());
            }
        }, 0L, 2L, TimeUnit.MINUTES) : BoxedUnit.UNIT;
    }
}

