/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.gateway.parser;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.linkis.common.ServiceInstance$;
import org.apache.linkis.gateway.http.GatewayContext;
import org.apache.linkis.gateway.http.GatewayRoute;
import org.apache.linkis.gateway.parser.AbstractGatewayParser;
import org.apache.linkis.gateway.parser.AbstractGatewayParser$;
import org.apache.linkis.gateway.parser.GatewayParser;
import org.apache.linkis.rpc.conf.RPCConfiguration$;
import org.apache.linkis.server.conf.ServerConfiguration$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0001\u0002\u0001\u001b\t!B)\u001a4bk2$x)\u0019;fo\u0006L\b+\u0019:tKJT!a\u0001\u0003\u0002\rA\f'o]3s\u0015\t)a!A\u0004hCR,w/Y=\u000b\u0005\u001dA\u0011A\u00027j].L7O\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\t\u000e\u0003\tI!!\u0005\u0002\u0003+\u0005\u00137\u000f\u001e:bGR<\u0015\r^3xCf\u0004\u0016M]:fe\"A1\u0003\u0001B\u0001B\u0003%A#\u0001\bhCR,w/Y=QCJ\u001cXM]:\u0011\u0007UA\"$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0015\t%O]1z!\ty1$\u0003\u0002\u001d\u0005\tiq)\u0019;fo\u0006L\b+\u0019:tKJDQA\b\u0001\u0005\u0002}\ta\u0001P5oSRtDC\u0001\u0011\"!\ty\u0001\u0001C\u0003\u0014;\u0001\u0007A\u0003C\u0004$\u0001\t\u0007I\u0011\u0002\u0013\u0002\u0019\r{U*T(O?J+u)\u0012-\u0016\u0003\u0015\u0002\"AJ\u0016\u000e\u0003\u001dR!\u0001K\u0015\u0002\u00115\fGo\u00195j]\u001eT!A\u000b\f\u0002\tU$\u0018\u000e\\\u0005\u0003Y\u001d\u0012QAU3hKbDaA\f\u0001!\u0002\u0013)\u0013!D\"P\u001b6{ej\u0018*F\u000f\u0016C\u0006\u0005C\u00041\u0001\t\u0007I\u0011\u0002\u0013\u0002-\rc\u0015*\u0012(U?\"+\u0015I\u0015+C\u000b\u0006#vLU#H\u000bbCaA\r\u0001!\u0002\u0013)\u0013aF\"M\u0013\u0016sEk\u0018%F\u0003J#&)R!U?J+u)\u0012-!\u0011\u0015!\u0004\u0001\"\u00116\u0003a\u0019\bn\\;mI\u000e{g\u000e^1j]J+\u0017/^3ti\n{G-\u001f\u000b\u0003me\u0002\"!F\u001c\n\u0005a2\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006uM\u0002\raO\u0001\u000fO\u0006$Xm^1z\u0007>tG/\u001a=u!\tat(D\u0001>\u0015\tqD!\u0001\u0003iiR\u0004\u0018B\u0001!>\u000599\u0015\r^3xCf\u001cuN\u001c;fqRDQA\u0011\u0001\u0005B\r\u000bQ\u0001]1sg\u0016$\"\u0001R$\u0011\u0005U)\u0015B\u0001$\u0017\u0005\u0011)f.\u001b;\t\u000bi\n\u0005\u0019A\u001e")
public class DefaultGatewayParser
extends AbstractGatewayParser {
    private final GatewayParser[] gatewayParsers;
    private final Regex COMMON_REGEX;
    private final Regex CLIENT_HEARTBEAT_REGEX;

    private Regex COMMON_REGEX() {
        return this.COMMON_REGEX;
    }

    private Regex CLIENT_HEARTBEAT_REGEX() {
        return this.CLIENT_HEARTBEAT_REGEX;
    }

    @Override
    public boolean shouldContainRequestBody(GatewayContext gatewayContext) {
        String string;
        boolean bl;
        String string2 = gatewayContext.getRequest().getMethod().toUpperCase();
        String string3 = "GET";
        return (string2 == null ? string3 != null : !string2.equals(string3)) && (bl = (string = gatewayContext.getRequest().getRequestURI()).startsWith((String)ServerConfiguration$.MODULE$.BDP_SERVER_USER_URI().getValue()) ? true : Predef$.MODULE$.refArrayOps((Object[])this.gatewayParsers).exists((Function1)new Serializable(this, gatewayContext){
            public static final long serialVersionUID = 0L;
            private final GatewayContext gatewayContext$2;

            public final boolean apply(GatewayParser x$2) {
                return x$2.shouldContainRequestBody(this.gatewayContext$2);
            }
            {
                this.gatewayContext$2 = gatewayContext$2;
            }
        }));
    }

    @Override
    public void parse(GatewayContext gatewayContext) {
        String path = gatewayContext.getRequest().getRequestURI();
        if (gatewayContext.getGatewayRoute() == null) {
            gatewayContext.setGatewayRoute(new GatewayRoute());
            gatewayContext.getGatewayRoute().setRequestURI(path);
        }
        Predef$.MODULE$.refArrayOps((Object[])this.gatewayParsers).foreach((Function1)new Serializable(this, gatewayContext){
            public static final long serialVersionUID = 0L;
            private final GatewayContext gatewayContext$3;

            public final void apply(GatewayParser x$3) {
                x$3.parse(this.gatewayContext$3);
            }
            {
                this.gatewayContext$3 = gatewayContext$3;
            }
        });
        if (gatewayContext.getGatewayRoute().getServiceInstance() == null) {
            String string = path;
            Option option = this.CLIENT_HEARTBEAT_REGEX().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                String version = (String)((LinearSeqOptimized)option.get()).apply(0);
                if (this.sendResponseWhenNotMatchVersion(gatewayContext, version)) {
                    return;
                }
                this.info((Function0<String>)new Serializable(this, gatewayContext){
                    public static final long serialVersionUID = 0L;
                    private final GatewayContext gatewayContext$3;

                    public final String apply() {
                        return Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.gatewayContext$3.getRequest().getRemoteAddress()), " try to heartbeat.");
                    }
                    {
                        this.gatewayContext$3 = gatewayContext$3;
                    }
                });
                this.responseHeartbeat(gatewayContext);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Option option2 = this.COMMON_REGEX().unapplySeq((CharSequence)string);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                    String version = (String)((LinearSeqOptimized)option2.get()).apply(0);
                    String serviceId = (String)((LinearSeqOptimized)option2.get()).apply(1);
                    if (this.sendResponseWhenNotMatchVersion(gatewayContext, version)) {
                        return;
                    }
                    String applicationName = BoxesRunTime.unboxToBoolean((Object)RPCConfiguration$.MODULE$.ENABLE_PUBLIC_SERVICE().getValue()) && Predef$.MODULE$.refArrayOps((Object[])RPCConfiguration$.MODULE$.PUBLIC_SERVICE_LIST()).contains((Object)serviceId) ? (String)RPCConfiguration$.MODULE$.PUBLIC_SERVICE_APPLICATION_NAME().getValue() : serviceId;
                    gatewayContext.getGatewayRoute().setServiceInstance(ServiceInstance$.MODULE$.apply(applicationName, null));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (string.startsWith("/dws/")) {
                    HashMap<String, String> params = gatewayContext.getGatewayRoute().getParams();
                    params.put("proxyId", "dws");
                    String secondaryProxyId = StringUtils.substringBetween((String)string, (String)"/dws/", (String)"/");
                    Object object = StringUtils.isNotBlank((String)secondaryProxyId) ? params.put("proxyId", new StringBuilder().append((Object)"dws/").append((Object)secondaryProxyId).toString()) : BoxedUnit.UNIT;
                    gatewayContext.getGatewayRoute().setParams(params);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.sendErrorResponse(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find a service to deal ", ", ignore it."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), gatewayContext);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        }
    }

    public DefaultGatewayParser(GatewayParser[] gatewayParsers) {
        this.gatewayParsers = gatewayParsers;
        this.COMMON_REGEX = new StringOps(Predef$.MODULE$.augmentString("/api/rest_[a-zA-Z]+/(v\\d+)/([^/]+)/.+")).r();
        this.CLIENT_HEARTBEAT_REGEX = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/api/rest_[a-zA-Z]+/(v\\\\d+)/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])AbstractGatewayParser$.MODULE$.GATEWAY_HEART_BEAT_URL()).mkString("/")})))).r();
    }
}

