/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.gateway.security;

import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.RSAUtils$;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.gateway.config.GatewayConfiguration$;
import org.apache.linkis.gateway.http.GatewayContext;
import org.apache.linkis.gateway.security.GatewaySSOUtils$;
import org.apache.linkis.gateway.security.ProxyUserUtils$;
import org.apache.linkis.gateway.security.SecurityHook;
import org.apache.linkis.gateway.security.UserRestful;
import org.apache.linkis.gateway.security.sso.SSOInterceptor$;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.Sender$;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.Message$;
import org.apache.linkis.server.conf.ServerConfiguration$;
import org.apache.linkis.server.package$;
import org.apache.linkis.server.security.SSOUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma!B\u0001\u0003\u0003\u0003i!aE!cgR\u0014\u0018m\u0019;Vg\u0016\u0014(+Z:uMVd'BA\u0002\u0005\u0003!\u0019XmY;sSRL(BA\u0003\u0007\u0003\u001d9\u0017\r^3xCfT!a\u0002\u0005\u0002\r1Lgn[5t\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\u000b\u0019!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\f+N,'OU3ti\u001a,H\u000e\u0005\u0002\u001a=5\t!D\u0003\u0002\u001c9\u0005)Q\u000f^5mg*\u0011QDB\u0001\u0007G>lWn\u001c8\n\u0005}Q\"a\u0002'pO\u001eLgn\u001a\u0005\u0006C\u0001!\tAI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u0002\"!\u0006\u0001\t\u000f\u0015\u0002\u0001\u0019!C\u0005M\u0005i1/Z2ve&$\u0018\u0010S8pWN,\u0012a\n\t\u0004\u001f!R\u0013BA\u0015\u0011\u0005\u0015\t%O]1z!\t)2&\u0003\u0002-\u0005\ta1+Z2ve&$\u0018\u0010S8pW\"9a\u0006\u0001a\u0001\n\u0013y\u0013!E:fGV\u0014\u0018\u000e^=I_>\\7o\u0018\u0013fcR\u0011\u0001g\r\t\u0003\u001fEJ!A\r\t\u0003\tUs\u0017\u000e\u001e\u0005\bi5\n\t\u00111\u0001(\u0003\rAH%\r\u0005\u0007m\u0001\u0001\u000b\u0015B\u0014\u0002\u001dM,7-\u001e:jifDun\\6tA!9\u0001\b\u0001b\u0001\n\u0003I\u0014\u0001\u00053tgB\u0013xN[3diN+g\u000eZ3s+\u0005Q\u0004CA\u001e?\u001b\u0005a$BA\u001f\u0007\u0003\r\u0011\boY\u0005\u0003\u007fq\u0012aaU3oI\u0016\u0014\bBB!\u0001A\u0003%!(A\tegN\u0004&o\u001c6fGR\u001cVM\u001c3fe\u0002BQa\u0011\u0001\u0005\u0002\u0011\u000b\u0001c]3u'\u0016\u001cWO]5us\"{wn[:\u0015\u0005A*\u0005\"B\u0013C\u0001\u00049\u0003bB$\u0001\u0005\u0004%I\u0001S\u0001\nkN,'OU3hKb,\u0012!\u0013\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000bA\u0001\\1oO*\ta*\u0001\u0003kCZ\f\u0017B\u0001)L\u0005\u0019\u0019FO]5oO\"1!\u000b\u0001Q\u0001\n%\u000b!\"^:feJ+w-\u001a=!\u0011\u0015!\u0006\u0001\"\u0011V\u00035!w.V:feJ+\u0017/^3tiR\u0011\u0001G\u0016\u0005\u0006/N\u0003\r\u0001W\u0001\u000fO\u0006$Xm^1z\u0007>tG/\u001a=u!\tIF,D\u0001[\u0015\tYF!\u0001\u0003iiR\u0004\u0018BA/[\u000599\u0015\r^3xCf\u001cuN\u001c;fqRDQa\u0018\u0001\u0005\u0002\u0001\fQ\u0001\u001d:pqf$\"!Y4\u0011\u0005\t,W\"A2\u000b\u0005\u00114\u0011AB:feZ,'/\u0003\u0002gG\n9Q*Z:tC\u001e,\u0007\"B,_\u0001\u0004A\u0006\"B5\u0001\t\u0003Q\u0017!\u00027pO&tGCA1l\u0011\u00159\u0006\u000e1\u0001Y\u0011\u0015i\u0007\u0001\"\u0001o\u0003!\u0011XmZ5ti\u0016\u0014HCA1p\u0011\u00159F\u000e1\u0001Y\u0011\u0015\t\bA\"\u0005s\u0003!!(/\u001f'pO&tGCA1t\u0011\u0015!\b\u000f1\u0001Y\u0003\u001d\u0019wN\u001c;fqRDQA\u001e\u0001\u0005\u0002]\fa\u0001\\8h_V$HCA1y\u0011\u00159V\u000f1\u0001Y\u0011\u0015Q\b\u0001\"\u0001|\u0003!)8/\u001a:J]\u001a|GCA1}\u0011\u00159\u0016\u00101\u0001Y\u0011\u0015q\b\u0001\"\u0001\u0000\u0003%\u0001XO\u00197jG.+\u0017\u0010F\u0002b\u0003\u0003AQaV?A\u0002aCq!!\u0002\u0001\t\u0003\t9!A\u0005iK\u0006\u0014HOY3biR\u0019\u0011-!\u0003\t\r]\u000b\u0019\u00011\u0001Y\u0011\u001d\ti\u0001\u0001D\t\u0003\u001f\t1\u0002\u001e:z%\u0016<\u0017n\u001d;feR\u0019\u0011-!\u0005\t\rQ\fY\u00011\u0001Y\u0001")
public abstract class AbstractUserRestful
implements UserRestful,
Logging {
    private SecurityHook[] securityHooks;
    private final Sender dssProjectSender;
    private final String userRegex;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        AbstractUserRestful abstractUserRestful = this;
        synchronized (abstractUserRestful) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<String> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.class.info((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.class.error((Logging)this, message);
    }

    private SecurityHook[] securityHooks() {
        return this.securityHooks;
    }

    private void securityHooks_$eq(SecurityHook[] x$1) {
        this.securityHooks = x$1;
    }

    public Sender dssProjectSender() {
        return this.dssProjectSender;
    }

    public void setSecurityHooks(SecurityHook[] securityHooks) {
        this.securityHooks_$eq(securityHooks);
    }

    private String userRegex() {
        return this.userRegex;
    }

    @Override
    public void doUserRequest(GatewayContext gatewayContext) {
        String path = gatewayContext.getRequest().getRequestURI().replace(this.userRegex(), "");
        String string = path;
        Message message = "register".equals(string) ? this.register(gatewayContext) : ("login".equals(string) ? (Message)Utils$.MODULE$.tryCatch((Function0)new Serializable(this, gatewayContext){
            public static final long serialVersionUID = 0L;
            private final GatewayContext gatewayContext$2;

            public final Message apply() {
                String loginUser = GatewaySSOUtils$.MODULE$.getLoginUsername(this.gatewayContext$2);
                return Message$.MODULE$.ok(new StringBuilder().append((Object)loginUser).append((Object)"Already logged in, please log out before signing in(\u5df2\u7ecf\u767b\u5f55\uff0c\u8bf7\u5148\u9000\u51fa\u518d\u8fdb\u884c\u767b\u5f55)\uff01").toString()).data("userName", (Object)loginUser);
            }
            {
                this.gatewayContext$2 = gatewayContext$2;
            }
        }, (Function1)new Serializable(this, gatewayContext){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractUserRestful $outer;
            private final GatewayContext gatewayContext$2;

            public final Message apply(Throwable x$1) {
                return this.$outer.login(this.gatewayContext$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.gatewayContext$2 = gatewayContext$2;
            }
        }) : ("logout".equals(string) ? this.logout(gatewayContext) : ("userInfo".equals(string) ? this.userInfo(gatewayContext) : ("publicKey".equals(string) ? this.publicKey(gatewayContext) : ("heartbeat".equals(string) ? this.heartbeat(gatewayContext) : ("proxy".equals(string) ? this.proxy(gatewayContext) : Message$.MODULE$.error(new StringBuilder().append((Object)"unknown request URI ").append((Object)path).toString())))))));
        Message message2 = message;
        gatewayContext.getResponse().write(Message$.MODULE$.response(message2));
        gatewayContext.getResponse().setStatus(Message$.MODULE$.messageToHttpStatus(message2));
        gatewayContext.getResponse().sendResponse();
    }

    public Message proxy(GatewayContext gatewayContext) {
        Message message;
        String validationCode;
        String proxyUser = gatewayContext.getRequest().getQueryParams().get("proxyUser")[0];
        if (ProxyUserUtils$.MODULE$.validate(proxyUser, validationCode = gatewayContext.getRequest().getQueryParams().get("validationCode")[0])) {
            String lowerCaseUserName = proxyUser.toString().toLowerCase();
            GatewaySSOUtils$.MODULE$.setLoginUser(gatewayContext, lowerCaseUserName);
            message = package$.MODULE$.ok("\u4ee3\u7406\u6210\u529f").data("proxyUser", (Object)proxyUser);
        } else {
            message = Message$.MODULE$.error("Validation failed");
        }
        return message;
    }

    /*
     * WARNING - void declaration
     */
    public Message login(GatewayContext gatewayContext) {
        void var2_2;
        Message message = this.tryLogin(gatewayContext);
        message.data("sessionTimeOut", (Object)BoxesRunTime.boxToLong((long)SSOUtils$.MODULE$.getSessionTimeOut())).data("enableWatermark", GatewayConfiguration$.MODULE$.ENABLE_WATER_MARK().getValue());
        if (this.securityHooks() != null) {
            Predef$.MODULE$.refArrayOps((Object[])this.securityHooks()).foreach((Function1)new Serializable(this, gatewayContext){
                public static final long serialVersionUID = 0L;
                private final GatewayContext gatewayContext$1;

                public final void apply(SecurityHook x$2) {
                    x$2.postLogin(this.gatewayContext$1);
                }
                {
                    this.gatewayContext$1 = gatewayContext$1;
                }
            });
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Message register(GatewayContext gatewayContext) {
        void var2_2;
        Message message = this.tryRegister(gatewayContext);
        return var2_2;
    }

    public abstract Message tryLogin(GatewayContext var1);

    public Message logout(GatewayContext gatewayContext) {
        GatewaySSOUtils$.MODULE$.removeLoginUser(gatewayContext);
        if (BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.ENABLE_SSO_LOGIN().getValue())) {
            SSOInterceptor$.MODULE$.getSSOInterceptor().logout(gatewayContext);
        }
        if (this.securityHooks() != null) {
            Predef$.MODULE$.refArrayOps((Object[])this.securityHooks()).foreach((Function1)new Serializable(this, gatewayContext){
                public static final long serialVersionUID = 0L;
                private final GatewayContext gatewayContext$3;

                public final void apply(SecurityHook x$3) {
                    x$3.preLogout(this.gatewayContext$3);
                }
                {
                    this.gatewayContext$3 = gatewayContext$3;
                }
            });
        }
        return package$.MODULE$.ok("Logout successful(\u9000\u51fa\u767b\u5f55\u6210\u529f)\uff01");
    }

    public Message userInfo(GatewayContext gatewayContext) {
        return package$.MODULE$.ok("get user information succeed!").data("userName", (Object)GatewaySSOUtils$.MODULE$.getLoginUsername(gatewayContext));
    }

    /*
     * WARNING - void declaration
     */
    public Message publicKey(GatewayContext gatewayContext) {
        void var2_2;
        BoxedUnit boxedUnit;
        Message message = Message$.MODULE$.ok("Gain success(\u83b7\u53d6\u6210\u529f)\uff01").data("enableSSL", (Object)BoxesRunTime.boxToBoolean((boolean)SSOUtils$.MODULE$.sslEnable()));
        if (BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.LOGIN_ENCRYPT_ENABLE().getValue())) {
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DEBUG: privateKey : "})).s((Seq)Nil$.MODULE$)).append((Object)RSAUtils$.MODULE$.getDefaultPrivateKey()).toString();
                }
            });
            long timeStamp = System.currentTimeMillis();
            this.info((Function0<String>)new Serializable(this, timeStamp){
                public static final long serialVersionUID = 0L;
                private final long timeStamp$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DEBUG: time "})).s((Seq)Nil$.MODULE$)).append((Object)BoxesRunTime.boxToLong((long)this.timeStamp$1)).toString();
                }
                {
                    this.timeStamp$1 = timeStamp$1;
                }
            });
            message.data("debugTime", (Object)BoxesRunTime.boxToLong((long)timeStamp));
            boxedUnit = message.data("publicKey", (Object)RSAUtils$.MODULE$.getDefaultPublicKey());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        message.data("enableLoginEncrypt", GatewayConfiguration$.MODULE$.LOGIN_ENCRYPT_ENABLE().getValue());
        return var2_2;
    }

    public Message heartbeat(GatewayContext gatewayContext) {
        return (Message)Utils$.MODULE$.tryCatch((Function0)new Serializable(this, gatewayContext){
            public static final long serialVersionUID = 0L;
            private final GatewayContext gatewayContext$4;

            /*
             * WARNING - void declaration
             */
            public final Message apply() {
                void var1_1;
                GatewaySSOUtils$.MODULE$.getLoginUsername(this.gatewayContext$4);
                Message retMessage = Message$.MODULE$.ok("Maintain heartbeat success(\u7ef4\u7cfb\u5fc3\u8df3\u6210\u529f)");
                retMessage.setStatus(0);
                return var1_1;
            }
            {
                this.gatewayContext$4 = gatewayContext$4;
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(Throwable t) {
                return Message$.MODULE$.noLogin(t.getMessage());
            }
        });
    }

    public abstract Message tryRegister(GatewayContext var1);

    /*
     * WARNING - void declaration
     */
    public AbstractUserRestful() {
        void var1_1;
        Logging.class.$init$((Logging)this);
        this.securityHooks = (SecurityHook[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(SecurityHook.class));
        this.dssProjectSender = Sender$.MODULE$.getSender((String)GatewayConfiguration$.MODULE$.DSS_QUERY_WORKSPACE_SERVICE_NAME().getValue());
        String userURI = (String)ServerConfiguration$.MODULE$.BDP_SERVER_USER_URI().getValue();
        if (!userURI.endsWith("/")) {
            userURI = new StringBuilder().append((Object)userURI).append((Object)"/").toString();
        }
        this.userRegex = var1_1;
    }
}

