/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.gateway.security;

import com.google.gson.Gson;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.util.Base64;
import org.apache.linkis.common.utils.RSAUtils$;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.gateway.config.GatewayConfiguration$;
import org.apache.linkis.gateway.http.GatewayContext;
import org.apache.linkis.gateway.security.AbstractUserRestful;
import org.apache.linkis.gateway.security.GatewaySSOUtils$;
import org.apache.linkis.gateway.security.UserPwdAbstractUserRestful$;
import org.apache.linkis.protocol.usercontrol.RequestLogin;
import org.apache.linkis.protocol.usercontrol.RequestRegister;
import org.apache.linkis.protocol.usercontrol.ResponseLogin;
import org.apache.linkis.protocol.usercontrol.ResponseRegister;
import org.apache.linkis.rpc.Sender;
import org.apache.linkis.rpc.Sender$;
import org.apache.linkis.server.BDPJettyServerHelper$;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.Message$;
import org.apache.linkis.server.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001m4Q!\u0001\u0002\u0002\u00025\u0011!$V:feB;H-\u00112tiJ\f7\r^+tKJ\u0014Vm\u001d;gk2T!a\u0001\u0003\u0002\u0011M,7-\u001e:jifT!!\u0002\u0004\u0002\u000f\u001d\fG/Z<bs*\u0011q\u0001C\u0001\u0007Y&t7.[:\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001aB\u0005\t\u0003\u001fAi\u0011AA\u0005\u0003#\t\u00111#\u00112tiJ\f7\r^+tKJ\u0014Vm\u001d;gk2\u0004\"a\u0005\r\u000e\u0003QQ!!\u0006\f\u0002\u000bU$\u0018\u000e\\:\u000b\u0005]1\u0011AB2p[6|g.\u0003\u0002\u001a)\t9Aj\\4hS:<\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\ty\u0001\u0001C\u0004 \u0001\t\u0007I\u0011\u0002\u0011\u0002\rM,g\u000eZ3s+\u0005\t\u0003C\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\u0007\u0003\r\u0011\boY\u0005\u0003M\r\u0012aaU3oI\u0016\u0014\bB\u0002\u0015\u0001A\u0003%\u0011%A\u0004tK:$WM\u001d\u0011\t\u000f)\u0002!\u0019!C\u0005W\u0005qA*\u0013(F?\u0012+E*S'J)\u0016\u0013V#\u0001\u0017\u0011\u00055\u0012T\"\u0001\u0018\u000b\u0005=\u0002\u0014\u0001\u00027b]\u001eT\u0011!M\u0001\u0005U\u00064\u0018-\u0003\u00024]\t11\u000b\u001e:j]\u001eDa!\u000e\u0001!\u0002\u0013a\u0013a\u0004'J\u001d\u0016{F)\u0012'J\u001b&#VI\u0015\u0011\t\u000f]\u0002!\u0019!C\u0005W\u0005aQkU#S\u001d\u0006kUiX*U%\"1\u0011\b\u0001Q\u0001\n1\nQ\"V*F%:\u000bU*R0T)J\u0003\u0003bB\u001e\u0001\u0005\u0004%IaK\u0001\u000b!\u0006\u001b6k\u0016#`'R\u0013\u0006BB\u001f\u0001A\u0003%A&A\u0006Q\u0003N\u001bv\u000bR0T)J\u0003\u0003bB \u0001\u0005\u0004%IaK\u0001\u0013!\u0006\u001b6k\u0016#`\u000b:\u001b%+\u0017)U?N#&\u000b\u0003\u0004B\u0001\u0001\u0006I\u0001L\u0001\u0014!\u0006\u001b6k\u0016#`\u000b:\u001b%+\u0017)U?N#&\u000b\t\u0005\u0006\u0007\u0002!I\u0001R\u0001\u0012O\u0016$Xk]3s\u001d\u0006lW-\u00118e!^#ECA#R!\u00111\u0015jS&\u000e\u0003\u001dS\u0011\u0001S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0015\u001e\u0013a\u0001V;qY\u0016\u0014\u0004C\u0001'P\u001d\t1U*\u0003\u0002O\u000f\u00061\u0001K]3eK\u001aL!a\r)\u000b\u00059;\u0005\"\u0002*C\u0001\u0004\u0019\u0016AD4bi\u0016<\u0018-_\"p]R,\u0007\u0010\u001e\t\u0003)^k\u0011!\u0016\u0006\u0003-\u0012\tA\u0001\u001b;ua&\u0011\u0001,\u0016\u0002\u000f\u000f\u0006$Xm^1z\u0007>tG/\u001a=u\u0011\u0015Q\u0006\u0001\"\u0015\\\u0003!!(/\u001f'pO&tGC\u0001/c!\ti\u0006-D\u0001_\u0015\tyf!\u0001\u0004tKJ4XM]\u0005\u0003Cz\u0013q!T3tg\u0006<W\rC\u0003S3\u0002\u00071\u000bC\u0003e\u0001\u0019EQ-A\u0003m_\u001eLg\u000eF\u0002]M\"DQaZ2A\u0002-\u000b\u0001\"^:fe:\u000bW.\u001a\u0005\u0006S\u000e\u0004\raS\u0001\ta\u0006\u001c8o^8sI\")1\u000e\u0001C\u0005Y\u0006\u0011r-\u001a;SC:$w.\u001c)s_bLXk]3s)\u0005Y\u0005\"\u00028\u0001\t\u0003y\u0017\u0001E;tKJ\u001cuN\u001c;s_2dunZ5o)\u0011a\u0006/\u001d:\t\u000b\u001dl\u0007\u0019A&\t\u000b%l\u0007\u0019A&\t\u000bIk\u0007\u0019A*\t\u000bQ\u0004A\u0011I;\u0002\u0017Q\u0014\u0018PU3hSN$XM\u001d\u000b\u00039ZDQAU:A\u0002MCQ\u0001\u001f\u0001\u0005\ne\f1#^:fe\u000e{g\u000e\u001e:pYJ+w-[:uKJ$\"\u0001\u0018>\t\u000bI;\b\u0019A*")
public abstract class UserPwdAbstractUserRestful
extends AbstractUserRestful {
    private final Sender org$apache$linkis$gateway$security$UserPwdAbstractUserRestful$$sender = Sender$.MODULE$.getSender((String)GatewayConfiguration$.MODULE$.USERCONTROL_SPRING_APPLICATION_NAME().getValue());
    private final String LINE_DELIMITER;
    private final String USERNAME_STR;
    private final String PASSWD_STR;
    private final String PASSWD_ENCRYPT_STR;

    public Sender org$apache$linkis$gateway$security$UserPwdAbstractUserRestful$$sender() {
        return this.org$apache$linkis$gateway$security$UserPwdAbstractUserRestful$$sender;
    }

    private String LINE_DELIMITER() {
        return this.LINE_DELIMITER;
    }

    private String USERNAME_STR() {
        return this.USERNAME_STR;
    }

    private String PASSWD_STR() {
        return this.PASSWD_STR;
    }

    private String PASSWD_ENCRYPT_STR() {
        return this.PASSWD_ENCRYPT_STR;
    }

    private Tuple2<String, String> getUserNameAndPWD(GatewayContext gatewayContext) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        String[] userNameArray = gatewayContext.getRequest().getQueryParams().get(this.USERNAME_STR());
        String[] passwordArray = gatewayContext.getRequest().getQueryParams().get(this.PASSWD_STR());
        String[] passwordArrayEncrypt = gatewayContext.getRequest().getQueryParams().get(this.PASSWD_ENCRYPT_STR());
        if (passwordArray == null || Predef$.MODULE$.refArrayOps((Object[])passwordArray).isEmpty() || StringUtils.isBlank((String)((String)Predef$.MODULE$.refArrayOps((Object[])passwordArray).head()))) {
            passwordArray = passwordArrayEncrypt;
        }
        if (userNameArray != null && Predef$.MODULE$.refArrayOps((Object[])userNameArray).nonEmpty() && passwordArray != null && Predef$.MODULE$.refArrayOps((Object[])passwordArray).nonEmpty()) {
            tuple22 = new Tuple2(Predef$.MODULE$.refArrayOps((Object[])userNameArray).head(), Predef$.MODULE$.refArrayOps((Object[])passwordArray).head());
        } else if (StringUtils.isNotBlank((String)gatewayContext.getRequest().getRequestBody())) {
            Map json = (Map)BDPJettyServerHelper$.MODULE$.gson().fromJson(gatewayContext.getRequest().getRequestBody(), Map.class);
            Object tmpUsername = json.getOrDefault(this.USERNAME_STR(), null);
            Object tmpPasswd = json.getOrDefault(this.PASSWD_STR(), null);
            if (tmpPasswd == null) {
                tmpPasswd = json.getOrDefault(this.PASSWD_ENCRYPT_STR(), null);
            }
            tuple22 = new Tuple2(tmpUsername, tmpPasswd);
        } else {
            tuple22 = tuple2 = new Tuple2(null, null);
        }
        if (tuple2 != null) {
            String string;
            Tuple2 tuple23;
            Object userName = tuple2._1();
            Object passwordEncrypt = tuple2._2();
            Tuple2 tuple24 = tuple23 = new Tuple2(userName, passwordEncrypt);
            Object userName2 = tuple24._1();
            Object passwordEncrypt2 = tuple24._2();
            if (userName2 == null || StringUtils.isBlank((String)userName2.toString())) {
                return new Tuple2(null, null);
            }
            if (passwordEncrypt2 == null || StringUtils.isBlank((String)passwordEncrypt2.toString())) {
                return new Tuple2((Object)userName2.toString(), null);
            }
            if (BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.LOGIN_ENCRYPT_ENABLE().getValue())) {
                this.info((Function0<String>)new Serializable(this, userName2, passwordEncrypt2){
                    public static final long serialVersionUID = 0L;
                    private final Object userName$1;
                    private final Object passwordEncrypt$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"passwordEncrypt or : ", " username ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.passwordEncrypt$1, this.userName$1}));
                    }
                    {
                        this.userName$1 = userName$1;
                        this.passwordEncrypt$1 = passwordEncrypt$1;
                    }
                });
                string = (String)Utils$.MODULE$.tryAndError((Function0)new Serializable(this, passwordEncrypt2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ UserPwdAbstractUserRestful $outer;
                    public final Object passwordEncrypt$1;

                    public final String apply() {
                        this.$outer.info((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$4 $outer;

                            public final String apply() {
                                return new StringBuilder().append((Object)"\npasswdEncrypt : ").append(this.$outer.passwordEncrypt$1).append((Object)"\npublicKeyStr : ").append((Object)RSAUtils$.MODULE$.getDefaultPublicKey()).append((Object)"\nprivateKeyStr : ").append((Object)RSAUtils$.MODULE$.getDefaultPrivateKey()).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        byte[] passwdOriObj = RSAUtils$.MODULE$.decrypt(Base64.decodeBase64((byte[])((String)this.passwordEncrypt$1).getBytes(StandardCharsets.UTF_8)));
                        return new String(passwdOriObj, StandardCharsets.UTF_8);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.passwordEncrypt$1 = passwordEncrypt$1;
                    }
                }, this.logger());
            } else {
                string = (String)passwordEncrypt2;
            }
            String password = string;
            return new Tuple2((Object)userName2.toString(), (Object)password);
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public Message tryLogin(GatewayContext gatewayContext) {
        Tuple2<String, String> tuple2 = this.getUserNameAndPWD(gatewayContext);
        if (tuple2 != null) {
            Message message;
            Tuple2 tuple22;
            String userName = (String)tuple2._1();
            String password = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)userName, (Object)password);
            String userName2 = (String)tuple23._1();
            String password2 = (String)tuple23._2();
            if (StringUtils.isBlank((String)userName2)) {
                return Message$.MODULE$.error("Username can not be empty(\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a)\uff01");
            }
            if (StringUtils.isBlank((String)password2)) {
                return Message$.MODULE$.error("Password can not be blank(\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a)\uff01");
            }
            if (((String)GatewayConfiguration$.MODULE$.ADMIN_USER().getValue()).equals(userName2) && ((String)GatewayConfiguration$.MODULE$.ADMIN_PASSWORD().getValue()).equals(password2)) {
                GatewaySSOUtils$.MODULE$.setLoginUser(gatewayContext, userName2);
                message = package$.MODULE$.ok("login successful(\u767b\u5f55\u6210\u529f)\uff01").data("userName", (Object)userName2).data("isAdmin", (Object)BoxesRunTime.boxToBoolean((boolean)true));
            } else {
                Message message2 = Message$.MODULE$.ok();
                if (BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.USERCONTROL_SWITCH_ON().getValue())) {
                    message2 = this.userControlLogin(userName2, password2, gatewayContext);
                } else {
                    String lowerCaseUserName = userName2.toLowerCase();
                    message2 = this.login(lowerCaseUserName, password2);
                    if (message2.getStatus() == 0) {
                        GatewaySSOUtils$.MODULE$.setLoginUser(gatewayContext, lowerCaseUserName);
                    }
                }
                Object object = message2.getData().containsKey("errmsg") ? message2.setMessage(new StringBuilder().append((Object)message2.getMessage()).append((Object)this.LINE_DELIMITER()).append((Object)message2.getData().get("errmsg").toString()).toString()) : BoxedUnit.UNIT;
                message = message2;
            }
            return message;
        }
        throw new MatchError(tuple2);
    }

    public abstract Message login(String var1, String var2);

    /*
     * WARNING - void declaration
     */
    public String org$apache$linkis$gateway$security$UserPwdAbstractUserRestful$$getRandomProxyUser() {
        void var1_1;
        String name = null;
        String[] userList = GatewayConfiguration$.MODULE$.PROXY_USER_LIST();
        int size = Predef$.MODULE$.refArrayOps((Object[])userList).size();
        if (size <= 0) {
            this.warn((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid Gateway proxy user list"})).s((Seq)Nil$.MODULE$);
                }
            });
        } else {
            Random rand = new Random();
            name = userList[rand.nextInt(size)];
        }
        return var1_1;
    }

    public Message userControlLogin(String userName, String password, GatewayContext gatewayContext) {
        ObjectRef message = ObjectRef.create((Object)Message$.MODULE$.ok());
        RequestLogin requestLogin = new RequestLogin();
        requestLogin.setUserName(userName.toString()).setPassword(password.toString());
        Utils$.MODULE$.tryCatch((Function0)new Serializable(this, gatewayContext, message, requestLogin){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UserPwdAbstractUserRestful $outer;
            private final GatewayContext gatewayContext$5;
            private final ObjectRef message$1;
            private final RequestLogin requestLogin$1;

            public final Object apply() {
                Object object = this.$outer.org$apache$linkis$gateway$security$UserPwdAbstractUserRestful$$sender().ask((Object)this.requestLogin$1);
                if (object instanceof ResponseLogin) {
                    BoxedUnit boxedUnit;
                    ResponseLogin responseLogin = (ResponseLogin)object;
                    ((Message)this.message$1.elem).setStatus(Predef$.MODULE$.Integer2int(responseLogin.getStatus()));
                    Object object2 = StringUtils.isNotBlank((String)responseLogin.getErrMsg()) ? ((Message)this.message$1.elem).data("errmsg", (Object)responseLogin.getErrMsg()) : BoxedUnit.UNIT;
                    if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)0), (Object)responseLogin.getStatus())) {
                        ((Message)this.message$1.elem).setStatus(0);
                        ((Message)this.message$1.elem).setMessage("Login successful(\u767b\u5f55\u6210\u529f)");
                        String proxyUser = this.$outer.org$apache$linkis$gateway$security$UserPwdAbstractUserRestful$$getRandomProxyUser();
                        if (StringUtils.isNotBlank((String)proxyUser)) {
                            GatewaySSOUtils$.MODULE$.setLoginUser(this.gatewayContext$5, proxyUser);
                            boxedUnit = ((Message)this.message$1.elem).setMessage("Login successful(\u767b\u5f55\u6210\u529f)").data("userName", (Object)proxyUser).data("isAdmin", (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        } else {
                            this.message$1.elem = Message$.MODULE$.error("Invalid proxy user, please contact with administrator(\u4ee3\u7406\u7528\u6237\u65e0\u6548\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458)");
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        this.message$1.elem = Message$.MODULE$.error("Invalid username or password, please check and try again later(\u7528\u6237\u540d\u6216\u5bc6\u7801\u65e0\u6548\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5)");
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return boxedUnit2;
                }
                throw new MatchError(object);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.gatewayContext$5 = gatewayContext$5;
                this.message$1 = message$1;
                this.requestLogin$1 = requestLogin$1;
            }
        }, (Function1)new Serializable(this, message){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UserPwdAbstractUserRestful $outer;
            private final ObjectRef message$1;

            public final Message apply(Throwable t) {
                this.$outer.warn((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Login rpc request error, err message "})).s((Seq)Nil$.MODULE$);
                    }
                }, t);
                ((Message)this.message$1.elem).setStatus(1);
                ((Message)this.message$1.elem).setMessage("System error, please try again later(\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5)");
                return ((Message)this.message$1.elem).data("errmsg", (Object)t.getMessage());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.message$1 = message$1;
            }
        });
        return (Message)message.elem;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Message tryRegister(GatewayContext gatewayContext) {
        void var2_2;
        Message message = Message$.MODULE$.ok();
        message = BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.USERCONTROL_SWITCH_ON().getValue()) ? this.userControlRegister(gatewayContext) : Message$.MODULE$.error("\u8bf7\u81ea\u884c\u5b9e\u73b0\u6ce8\u518c\u65b9\u6cd5\uff01");
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Message userControlRegister(GatewayContext gatewayContext) {
        void var2_2;
        Message message = Message$.MODULE$.ok();
        Gson gson = new Gson();
        RequestRegister requestRegister = new RequestRegister();
        String requestBody = gatewayContext.getRequest().getRequestBody();
        Utils$.MODULE$.tryCatch((Function0)new Serializable(this, message, gson, requestRegister, requestBody){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UserPwdAbstractUserRestful $outer;
            private final Message message$2;
            public final Gson gson$1;
            public final RequestRegister requestRegister$1;
            private final String requestBody$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.requestRegister$1.setParams(this.requestBody$1);
                Object object = this.$outer.org$apache$linkis$gateway$security$UserPwdAbstractUserRestful$$sender().ask((Object)this.requestRegister$1);
                if (object instanceof ResponseRegister) {
                    ResponseRegister responseRegister = (ResponseRegister)object;
                    this.message$2.setStatus(responseRegister.getStatus());
                    this.message$2.setMessage(responseRegister.getMessage());
                    HashMap map = responseRegister.getData();
                    this.message$2.setData(map);
                    this.message$2.setMethod(responseRegister.getMethod());
                    this.$outer.info((Function0<String>)new Serializable(this, responseRegister){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$userControlRegister$1 $outer;
                        private final ResponseRegister x2$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Register rpc success. requestRegister="})).s((Seq)Nil$.MODULE$)).append((Object)this.$outer.gson$1.toJson((Object)this.$outer.requestRegister$1)).append((Object)", response=").append((Object)this.$outer.gson$1.toJson((Object)this.x2$1)).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.x2$1 = x2$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(object);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.message$2 = message$2;
                this.gson$1 = gson$1;
                this.requestRegister$1 = requestRegister$1;
                this.requestBody$1 = requestBody$1;
            }
        }, (Function1)new Serializable(this, message){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UserPwdAbstractUserRestful $outer;
            private final Message message$2;

            public final void apply(Throwable e) {
                this.$outer.warn((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Register rpc request error. err message "})).s((Seq)Nil$.MODULE$);
                    }
                }, e);
                this.message$2.setStatus(1);
                this.message$2.setMessage("System, please try again later(\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5)");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.message$2 = message$2;
            }
        });
        Object object = message.getData().containsKey("errmsg") ? message.setMessage(new StringBuilder().append((Object)message.getMessage()).append((Object)this.LINE_DELIMITER()).append((Object)message.getData().get("errmsg").toString()).toString()) : BoxedUnit.UNIT;
        return var2_2;
    }

    public UserPwdAbstractUserRestful() {
        this.LINE_DELIMITER = "</br>";
        this.USERNAME_STR = "userName";
        this.PASSWD_STR = "password";
        this.PASSWD_ENCRYPT_STR = "passwdEncrypt";
    }
}

