/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.instance.label;

import java.util.List;
import org.apache.linkis.instance.label.service.InsLabelAccessService;
import org.apache.linkis.instance.label.service.InsLabelServiceAdapter;
import org.apache.linkis.instance.label.service.annotation.AdapterMode;
import org.apache.linkis.instance.label.service.impl.DefaultInsLabelService;
import org.apache.linkis.instance.label.service.impl.DefaultInsLabelServiceAdapter;
import org.apache.linkis.instance.label.service.impl.SpringInsLabelService;
import org.apache.linkis.mybatis.DataSourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.AnnotationUtils;

@Configuration
public class InsLabelAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(InsLabelAutoConfiguration.class);

    @ConditionalOnClass(value={DataSourceConfig.class})
    @ConditionalOnMissingBean(value={DefaultInsLabelService.class})
    @Bean
    @Scope(value="prototype")
    public InsLabelAccessService defaultInsLabelService() {
        return new DefaultInsLabelService();
    }

    @ConditionalOnMissingBean(value={InsLabelServiceAdapter.class})
    @Bean
    public InsLabelServiceAdapter insLabelServiceAdapter(List<InsLabelAccessService> accessServices) {
        LOG.info("Discover instance label accessServices: [" + accessServices.size() + "]");
        DefaultInsLabelServiceAdapter insLabelServiceAdapter = new DefaultInsLabelServiceAdapter();
        accessServices.forEach(accessService -> {
            AdapterMode adapterMode = (AdapterMode)AnnotationUtils.findAnnotation(accessService.getClass(), AdapterMode.class);
            if (null != adapterMode) {
                LOG.info("Register instance label access service: " + accessService.getClass().getSimpleName() + " to service adapter");
                insLabelServiceAdapter.registerServices((InsLabelAccessService)accessService, adapterMode.order());
            }
        });
        return insLabelServiceAdapter;
    }

    public static class SpringClientConfiguration {
        @ConditionalOnMissingBean(value={SpringInsLabelService.class})
        @Bean
        @Scope(value="prototype")
        public SpringInsLabelService springInsLabelService(DiscoveryClient discoveryClient) {
            return new SpringInsLabelService(discoveryClient);
        }
    }
}

