/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.instance.label.restful;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.linkis.common.ServiceInstance;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.instance.label.entity.InstanceInfo;
import org.apache.linkis.instance.label.errorcode.LinkisInstanceLabelErrorCodeSummary;
import org.apache.linkis.instance.label.exception.InstanceErrorException;
import org.apache.linkis.instance.label.service.impl.DefaultInsLabelService;
import org.apache.linkis.instance.label.utils.EntityParser;
import org.apache.linkis.instance.label.vo.InstanceInfoVo;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactory;
import org.apache.linkis.manager.label.builder.factory.LabelBuilderFactoryContext;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.label.entity.UserModifiable;
import org.apache.linkis.manager.label.utils.LabelUtils;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"instance restful"})
@RestController
@RequestMapping(path={"/microservice"})
public class InstanceRestful {
    private static final Log logger = LogFactory.getLog(InstanceRestful.class);
    private LabelBuilderFactory labelBuilderFactory = LabelBuilderFactoryContext.getLabelBuilderFactory();
    @Autowired
    private DefaultInsLabelService insLabelService;

    @ApiOperation(value="listAllInstanceWithLabel", notes="list all instance with label", response=Message.class)
    @RequestMapping(path={"/allInstance"}, method={RequestMethod.GET})
    public Message listAllInstanceWithLabel(HttpServletRequest req) throws Exception {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"listAllInstanceWithLabel");
        if (Configuration.isNotAdmin((String)userName)) {
            throw new InstanceErrorException(String.format(LinkisInstanceLabelErrorCodeSummary.ONLY_ADMIN_CAN_VIEW.getErrorDesc() + "The user [%s] is not admin.", userName));
        }
        logger.info((Object)"start to get all instance informations.....");
        List<InstanceInfo> instances = this.insLabelService.listAllInstanceWithLabel();
        this.insLabelService.markInstanceLabel(instances);
        List<InstanceInfoVo> instanceVos = EntityParser.parseToInstanceVo(instances);
        logger.info((Object)("Done, all instance:" + instances));
        return Message.ok().data("instances", instanceVos);
    }

    @ApiOperation(value="upDateInstanceLabel", notes="up date instance label", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationName", dataType="String"), @ApiImplicitParam(name="instance", required=false, dataType="String", value="instance"), @ApiImplicitParam(name="labels", required=false, dataType="List", value="labels"), @ApiImplicitParam(name="labelKey", dataType="String"), @ApiImplicitParam(name="stringValue", dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"/instanceLabel"}, method={RequestMethod.PUT})
    public Message upDateInstanceLabel(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws Exception {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"upDateInstanceLabel");
        if (Configuration.isNotAdmin((String)userName)) {
            throw new InstanceErrorException(String.format(LinkisInstanceLabelErrorCodeSummary.ONLY_ADMIN_CAN_MODIFY.getErrorDesc() + " The user [%s] is not admin", userName));
        }
        String instanceName = jsonNode.get("instance").asText();
        String instanceType = jsonNode.get("applicationName").asText();
        if (StringUtils.isEmpty((CharSequence)instanceName)) {
            return Message.error((String)"instance cannot be empty(\u5b9e\u4f8b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)instanceType)) {
            return Message.error((String)"instance cannot be empty(\u5b9e\u4f8b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JsonNode labelsNode = jsonNode.get("labels");
        Iterator labelKeyIterator = labelsNode.iterator();
        ServiceInstance instance = ServiceInstance.apply((String)instanceType, (String)instanceName);
        ArrayList<Label> labels = new ArrayList<Label>();
        Set keyList = LabelUtils.listAllUserModifiableLabel();
        HashSet<String> labelKeySet = new HashSet<String>();
        while (labelKeyIterator.hasNext()) {
            JsonNode label = (JsonNode)labelKeyIterator.next();
            String labelKey = label.get("labelKey").asText();
            String labelStringValue = label.get("stringValue").asText();
            if (labelStringValue == null || !keyList.contains(labelKey)) continue;
            Label realLabel = this.labelBuilderFactory.createLabel(labelKey, (Object)labelStringValue);
            if (realLabel instanceof UserModifiable) {
                ((UserModifiable)realLabel).valueCheck(labelStringValue);
            }
            labelKeySet.add(labelKey);
            labels.add(realLabel);
        }
        if (labelKeySet.size() != labels.size()) {
            throw new InstanceErrorException(LinkisInstanceLabelErrorCodeSummary.INCLUDE_REPEAT.getErrorDesc());
        }
        this.insLabelService.refreshLabelsToInstance(labels, instance);
        InstanceInfo instanceInfo = this.insLabelService.getInstanceInfoByServiceInstance(instance);
        instanceInfo.setUpdateTime(new Date());
        this.insLabelService.updateInstance(instanceInfo);
        return Message.ok((String)"success").data("labels", labels);
    }

    @ApiOperation(value="listAllModifiableLabelKey", notes="list all modifiable label key", response=Message.class)
    @RequestMapping(path={"/modifiableLabelKey"}, method={RequestMethod.GET})
    public Message listAllModifiableLabelKey(HttpServletRequest req) {
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"upDateInstanceLabel");
        Set keyList = LabelUtils.listAllUserModifiableLabel();
        return Message.ok().data("keyList", (Object)keyList);
    }

    @ApiOperation(value="getServiceRegistryURL", response=Message.class)
    @RequestMapping(path={"/serviceRegistryURL"}, method={RequestMethod.GET})
    public Message getServiceRegistryURL(HttpServletRequest request) throws Exception {
        String serviceRegistryURL = this.insLabelService.getServiceRegistryURL();
        ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)"getServiceRegistryURL");
        return Message.ok().data("url", (Object)serviceRegistryURL);
    }
}

