/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.SparseFixedBitSet;
import org.apache.lucene.util.packed.BlockPackedReader;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;
import org.apache.lucene.util.packed.PackedInts;

@Deprecated
final class Lucene50NormsProducer
extends NormsProducer {
    private final Map<String, NormsEntry> norms;
    private final IndexInput data;
    final Map<String, Norms> instances;
    private final AtomicLong ramBytesUsed;
    private final AtomicInteger activeCount;
    private final int maxDoc;
    private final boolean merging;

    Lucene50NormsProducer(Lucene50NormsProducer original) {
        this.norms = new HashMap<String, NormsEntry>();
        this.instances = new HashMap<String, Norms>();
        this.activeCount = new AtomicInteger();
        assert (Thread.holdsLock((Object)original));
        this.norms.putAll(original.norms);
        this.data = original.data.clone();
        this.instances.putAll(original.instances);
        this.ramBytesUsed = new AtomicLong(original.ramBytesUsed.get());
        this.activeCount.set(original.activeCount.get());
        this.maxDoc = original.maxDoc;
        this.merging = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene50NormsProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        int version;
        block20: {
            this.norms = new HashMap<String, NormsEntry>();
            this.instances = new HashMap<String, Norms>();
            this.activeCount = new AtomicInteger();
            this.merging = false;
            this.maxDoc = state.segmentInfo.maxDoc();
            String metaName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)metaExtension);
            this.ramBytesUsed = new AtomicLong(RamUsageEstimator.shallowSizeOfInstance(((Object)((Object)this)).getClass()));
            version = -1;
            try (ChecksumIndexInput in = state.directory.openChecksumInput(metaName, state.context);){
                Throwable priorE = null;
                try {
                    version = CodecUtil.checkIndexHeader((DataInput)in, (String)metaCodec, (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                    this.readFields((IndexInput)in, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block20;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter((ChecksumIndexInput)in, (Throwable)priorE);
                    }
                }
                CodecUtil.checkFooter((ChecksumIndexInput)in, (Throwable)priorE);
            }
        }
        String dataName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)dataExtension);
        this.data = state.directory.openInput(dataName, state.context);
        boolean success = false;
        try {
            int version2 = CodecUtil.checkIndexHeader((DataInput)this.data, (String)dataCodec, (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
            if (version != version2) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + version + ",data=" + version2, (DataInput)this.data);
            }
            CodecUtil.retrieveChecksum((IndexInput)this.data);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.data});
            throw throwable;
        }
    }

    private void readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, (DataInput)meta);
            }
            if (!info.hasNorms()) {
                throw new CorruptIndexException("Invalid field: " + info.name, (DataInput)meta);
            }
            NormsEntry entry = this.readEntry(info, meta);
            this.norms.put(info.name, entry);
            fieldNumber = meta.readVInt();
        }
    }

    private NormsEntry readEntry(FieldInfo info, IndexInput meta) throws IOException {
        NormsEntry entry = new NormsEntry();
        entry.count = meta.readVInt();
        entry.format = meta.readByte();
        entry.offset = meta.readLong();
        switch (entry.format) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                if (meta.readVInt() != info.number) {
                    throw new CorruptIndexException("indirect norms entry for field: " + info.name + " is corrupt", (DataInput)meta);
                }
                entry.nested = this.readEntry(info, meta);
                break;
            }
            default: {
                throw new CorruptIndexException("Unknown format: " + entry.format, (DataInput)meta);
            }
        }
        return entry;
    }

    public synchronized NumericDocValues getNorms(FieldInfo field) throws IOException {
        Norms instance = this.instances.get(field.name);
        if (instance == null) {
            instance = this.loadNorms(this.norms.get(field.name));
            if (!this.merging) {
                this.instances.put(field.name, instance);
                this.activeCount.incrementAndGet();
                this.ramBytesUsed.addAndGet(instance.ramBytesUsed());
            }
        }
        return instance;
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed.get();
    }

    public synchronized Collection<Accountable> getChildResources() {
        return Accountables.namedAccountables((String)"field", this.instances);
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.data);
    }

    private Norms loadNorms(NormsEntry entry) throws IOException {
        switch (entry.format) {
            case 2: {
                final long v = entry.offset;
                return new Norms(){

                    public long get(int docID) {
                        return v;
                    }

                    public long ramBytesUsed() {
                        return 8L;
                    }

                    public String toString() {
                        return "constant";
                    }
                };
            }
            case 3: {
                this.data.seek(entry.offset);
                final byte[] bytes = new byte[entry.count];
                this.data.readBytes(bytes, 0, bytes.length);
                return new Norms(){

                    public long get(int docID) {
                        return bytes[docID];
                    }

                    public long ramBytesUsed() {
                        return RamUsageEstimator.sizeOf((byte[])bytes);
                    }

                    public String toString() {
                        return "byte array";
                    }
                };
            }
            case 0: {
                this.data.seek(entry.offset);
                int packedIntsVersion = this.data.readVInt();
                int blockSize = this.data.readVInt();
                final BlockPackedReader reader = new BlockPackedReader(this.data, packedIntsVersion, blockSize, (long)entry.count, false);
                return new Norms(){

                    public long get(int docID) {
                        return reader.get(docID);
                    }

                    public long ramBytesUsed() {
                        return reader.ramBytesUsed();
                    }

                    public Collection<Accountable> getChildResources() {
                        return Collections.singleton(reader);
                    }

                    public String toString() {
                        return "delta compressed";
                    }
                };
            }
            case 1: {
                int i;
                this.data.seek(entry.offset);
                int packedIntsVersion = this.data.readVInt();
                int formatID = this.data.readVInt();
                int bitsPerValue = this.data.readVInt();
                if (bitsPerValue != 1 && bitsPerValue != 2 && bitsPerValue != 4) {
                    throw new CorruptIndexException("TABLE_COMPRESSED only supports bpv=1, bpv=2 and bpv=4, got=" + bitsPerValue, (DataInput)this.data);
                }
                int size = 1 << bitsPerValue;
                final byte[] decode = new byte[size];
                int ordsSize = this.data.readVInt();
                for (i = 0; i < ordsSize; ++i) {
                    decode[i] = this.data.readByte();
                }
                for (i = ordsSize; i < size; ++i) {
                    decode[i] = 0;
                }
                final PackedInts.Reader ordsReader = PackedInts.getReaderNoHeader((DataInput)this.data, (PackedInts.Format)PackedInts.Format.byId((int)formatID), (int)packedIntsVersion, (int)entry.count, (int)bitsPerValue);
                return new Norms(){

                    public long get(int docID) {
                        return decode[(int)ordsReader.get(docID)];
                    }

                    public long ramBytesUsed() {
                        return RamUsageEstimator.sizeOf((byte[])decode) + ordsReader.ramBytesUsed();
                    }

                    public Collection<Accountable> getChildResources() {
                        return Collections.singleton(ordsReader);
                    }

                    public String toString() {
                        return "table compressed";
                    }
                };
            }
            case 4: {
                this.data.seek(entry.offset);
                final long common = this.data.readLong();
                int packedIntsVersion = this.data.readVInt();
                int blockSize = this.data.readVInt();
                final MonotonicBlockPackedReader live = MonotonicBlockPackedReader.of((IndexInput)this.data, (int)packedIntsVersion, (int)blockSize, (long)entry.count, (boolean)false);
                final Norms nestedInstance = this.loadNorms(entry.nested);
                final int upperBound = entry.count - 1;
                return new Norms(){

                    public long get(int docID) {
                        int low = 0;
                        int high = upperBound;
                        while (low <= high) {
                            int mid = low + high >>> 1;
                            long doc = live.get(mid);
                            if (doc < (long)docID) {
                                low = mid + 1;
                                continue;
                            }
                            if (doc > (long)docID) {
                                high = mid - 1;
                                continue;
                            }
                            return nestedInstance.get(mid);
                        }
                        return common;
                    }

                    public long ramBytesUsed() {
                        return live.ramBytesUsed() + nestedInstance.ramBytesUsed();
                    }

                    public Collection<Accountable> getChildResources() {
                        ArrayList<Accountable> children = new ArrayList<Accountable>();
                        children.add(Accountables.namedAccountable((String)"keys", (Accountable)live));
                        children.add(Accountables.namedAccountable((String)"values", (Accountable)nestedInstance));
                        return Collections.unmodifiableList(children);
                    }

                    public String toString() {
                        return "indirect";
                    }
                };
            }
            case 5: {
                this.data.seek(entry.offset);
                final long common = this.data.readLong();
                int packedIntsVersion = this.data.readVInt();
                int blockSize = this.data.readVInt();
                MonotonicBlockPackedReader live = MonotonicBlockPackedReader.of((IndexInput)this.data, (int)packedIntsVersion, (int)blockSize, (long)entry.count, (boolean)true);
                final SparseFixedBitSet set = new SparseFixedBitSet(this.maxDoc);
                int i = 0;
                while ((long)i < live.size()) {
                    int doc = (int)live.get(i);
                    set.set(doc);
                    ++i;
                }
                final Norms nestedInstance = this.loadNorms(entry.nested);
                return new Norms(){

                    public long get(int docID) {
                        if (set.get(docID)) {
                            return nestedInstance.get(docID);
                        }
                        return common;
                    }

                    public long ramBytesUsed() {
                        return set.ramBytesUsed() + nestedInstance.ramBytesUsed();
                    }

                    public Collection<Accountable> getChildResources() {
                        ArrayList<Accountable> children = new ArrayList<Accountable>();
                        children.add(Accountables.namedAccountable((String)"keys", (Accountable)set));
                        children.add(Accountables.namedAccountable((String)"values", (Accountable)nestedInstance));
                        return Collections.unmodifiableList(children);
                    }

                    public String toString() {
                        return "patched bitset";
                    }
                };
            }
            case 6: {
                this.data.seek(entry.offset);
                int packedIntsVersion = this.data.readVInt();
                int formatID = this.data.readVInt();
                int bitsPerValue = this.data.readVInt();
                if (bitsPerValue != 2 && bitsPerValue != 4) {
                    throw new CorruptIndexException("PATCHED_TABLE only supports bpv=2 and bpv=4, got=" + bitsPerValue, (DataInput)this.data);
                }
                int size = 1 << bitsPerValue;
                int ordsSize = this.data.readVInt();
                final byte[] decode = new byte[ordsSize];
                assert (ordsSize + 1 == size);
                for (int i = 0; i < ordsSize; ++i) {
                    decode[i] = this.data.readByte();
                }
                final PackedInts.Reader ordsReader = PackedInts.getReaderNoHeader((DataInput)this.data, (PackedInts.Format)PackedInts.Format.byId((int)formatID), (int)packedIntsVersion, (int)entry.count, (int)bitsPerValue);
                final Norms nestedInstance = this.loadNorms(entry.nested);
                return new Norms(){

                    public long get(int docID) {
                        int ord = (int)ordsReader.get(docID);
                        try {
                            return decode[ord];
                        }
                        catch (IndexOutOfBoundsException e) {
                            return nestedInstance.get(docID);
                        }
                    }

                    public long ramBytesUsed() {
                        return RamUsageEstimator.sizeOf((byte[])decode) + ordsReader.ramBytesUsed() + nestedInstance.ramBytesUsed();
                    }

                    public Collection<Accountable> getChildResources() {
                        ArrayList<Accountable> children = new ArrayList<Accountable>();
                        children.add(Accountables.namedAccountable((String)"common", (Accountable)ordsReader));
                        children.add(Accountables.namedAccountable((String)"uncommon", (Accountable)nestedInstance));
                        return Collections.unmodifiableList(children);
                    }

                    public String toString() {
                        return "patched table";
                    }
                };
            }
        }
        throw new AssertionError();
    }

    public void close() throws IOException {
        this.data.close();
    }

    public synchronized NormsProducer getMergeInstance() throws IOException {
        return new Lucene50NormsProducer(this);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(fields=" + this.norms.size() + ",active=" + this.activeCount.get() + ")";
    }

    static abstract class Norms
    extends NumericDocValues
    implements Accountable {
        Norms() {
        }
    }

    static class NormsEntry {
        byte format;
        long offset;
        int count;
        NormsEntry nested;

        NormsEntry() {
        }
    }
}

