/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.ContentSource;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.benchmark.byTask.utils.Config;

public class ConsumeContentSourceTask
extends PerfTask {
    private ContentSource source;
    private DocData dd = new DocData();

    public ConsumeContentSourceTask(PerfRunData runData) {
        super(runData);
        Config config = runData.getConfig();
        String sourceClass = config.get("content.source", null);
        if (sourceClass == null) {
            throw new IllegalArgumentException("content.source must be defined");
        }
        try {
            this.source = Class.forName(sourceClass).asSubclass(ContentSource.class).newInstance();
            this.source.setConfig(config);
            this.source.resetInputs();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getLogMessage(int recsCount) {
        return "read " + recsCount + " documents from the content source";
    }

    public void close() throws Exception {
        this.source.close();
        super.close();
    }

    public int doLogic() throws Exception {
        this.dd = this.source.getNextDocData(this.dd);
        return 1;
    }
}

