/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;

public class NearRealtimeReaderTask
extends PerfTask {
    long pauseMSec = 3000L;

    public NearRealtimeReaderTask(PerfRunData runData) {
        super(runData);
    }

    public int doLogic() throws Exception {
        PerfRunData runData = this.getRunData();
        IndexWriter w = runData.getIndexWriter();
        if (w == null) {
            throw new RuntimeException("please open the writer before invoking NearRealtimeReader");
        }
        if (runData.getIndexReader() != null) {
            throw new RuntimeException("please close the existing reader before invoking NearRealtimeReader");
        }
        long t = System.currentTimeMillis();
        IndexReader r = w.getReader();
        runData.setIndexReader(r);
        r.decRef();
        int reopenCount = 0;
        while (!this.stopNow) {
            long waitForMsec = this.pauseMSec - (System.currentTimeMillis() - t);
            if (waitForMsec > 0L) {
                Thread.sleep(waitForMsec);
            }
            t = System.currentTimeMillis();
            IndexReader newReader = r.reopen();
            if (r == newReader) continue;
            runData.setIndexReader(newReader);
            newReader.decRef();
            r = newReader;
            ++reopenCount;
        }
        return reopenCount;
    }

    public void setParams(String params) {
        super.setParams(params);
        this.pauseMSec = (long)(1000.0 * (double)Float.parseFloat(params));
    }

    public boolean supportsParams() {
        return true;
    }
}

