/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.simpletext.SimpleTextStoredFieldsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.UnicodeUtil;

public class SimpleTextStoredFieldsReader
extends StoredFieldsReader {
    private long[] offsets;
    private IndexInput in;
    private BytesRef scratch = new BytesRef();
    private CharsRef scratchUTF16 = new CharsRef();
    private final FieldInfos fieldInfos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleTextStoredFieldsReader(Directory directory, SegmentInfo si, FieldInfos fn, IOContext context) throws IOException {
        this.fieldInfos = fn;
        boolean success = false;
        try {
            this.in = directory.openInput(IndexFileNames.segmentFileName((String)si.name, (String)"", (String)"fld"), context);
            success = true;
        }
        finally {
            if (!success) {
                try {
                    this.close();
                }
                catch (Throwable t) {}
            }
        }
        this.readIndex(si.getDocCount());
    }

    SimpleTextStoredFieldsReader(long[] offsets, IndexInput in, FieldInfos fieldInfos) {
        this.offsets = offsets;
        this.in = in;
        this.fieldInfos = fieldInfos;
    }

    private void readIndex(int size) throws IOException {
        BufferedChecksumIndexInput input = new BufferedChecksumIndexInput(this.in);
        this.offsets = new long[size];
        int upto = 0;
        while (!this.scratch.equals((Object)SimpleTextStoredFieldsWriter.END)) {
            SimpleTextUtil.readLine((DataInput)input, this.scratch);
            if (!StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)SimpleTextStoredFieldsWriter.DOC)) continue;
            this.offsets[upto] = input.getFilePointer();
            ++upto;
        }
        SimpleTextUtil.checkFooter((ChecksumIndexInput)input);
        assert (upto == this.offsets.length);
    }

    public void visitDocument(int n, StoredFieldVisitor visitor) throws IOException {
        this.in.seek(this.offsets[n]);
        this.readLine();
        assert (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)SimpleTextStoredFieldsWriter.NUM));
        int numFields = this.parseIntAt(SimpleTextStoredFieldsWriter.NUM.length);
        block5: for (int i = 0; i < numFields; ++i) {
            BytesRef type;
            this.readLine();
            assert (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)SimpleTextStoredFieldsWriter.FIELD));
            int fieldNumber = this.parseIntAt(SimpleTextStoredFieldsWriter.FIELD.length);
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(fieldNumber);
            this.readLine();
            assert (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)SimpleTextStoredFieldsWriter.NAME));
            this.readLine();
            assert (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)SimpleTextStoredFieldsWriter.TYPE));
            if (this.equalsAt(SimpleTextStoredFieldsWriter.TYPE_STRING, this.scratch, SimpleTextStoredFieldsWriter.TYPE.length)) {
                type = SimpleTextStoredFieldsWriter.TYPE_STRING;
            } else if (this.equalsAt(SimpleTextStoredFieldsWriter.TYPE_BINARY, this.scratch, SimpleTextStoredFieldsWriter.TYPE.length)) {
                type = SimpleTextStoredFieldsWriter.TYPE_BINARY;
            } else if (this.equalsAt(SimpleTextStoredFieldsWriter.TYPE_INT, this.scratch, SimpleTextStoredFieldsWriter.TYPE.length)) {
                type = SimpleTextStoredFieldsWriter.TYPE_INT;
            } else if (this.equalsAt(SimpleTextStoredFieldsWriter.TYPE_LONG, this.scratch, SimpleTextStoredFieldsWriter.TYPE.length)) {
                type = SimpleTextStoredFieldsWriter.TYPE_LONG;
            } else if (this.equalsAt(SimpleTextStoredFieldsWriter.TYPE_FLOAT, this.scratch, SimpleTextStoredFieldsWriter.TYPE.length)) {
                type = SimpleTextStoredFieldsWriter.TYPE_FLOAT;
            } else if (this.equalsAt(SimpleTextStoredFieldsWriter.TYPE_DOUBLE, this.scratch, SimpleTextStoredFieldsWriter.TYPE.length)) {
                type = SimpleTextStoredFieldsWriter.TYPE_DOUBLE;
            } else {
                throw new RuntimeException("unknown field type");
            }
            switch (visitor.needsField(fieldInfo)) {
                case YES: {
                    this.readField(type, fieldInfo, visitor);
                    continue block5;
                }
                case NO: {
                    this.readLine();
                    assert (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)SimpleTextStoredFieldsWriter.VALUE));
                    continue block5;
                }
                case STOP: {
                    return;
                }
            }
        }
    }

    private void readField(BytesRef type, FieldInfo fieldInfo, StoredFieldVisitor visitor) throws IOException {
        this.readLine();
        assert (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)SimpleTextStoredFieldsWriter.VALUE));
        if (type == SimpleTextStoredFieldsWriter.TYPE_STRING) {
            visitor.stringField(fieldInfo, new String(this.scratch.bytes, this.scratch.offset + SimpleTextStoredFieldsWriter.VALUE.length, this.scratch.length - SimpleTextStoredFieldsWriter.VALUE.length, StandardCharsets.UTF_8));
        } else if (type == SimpleTextStoredFieldsWriter.TYPE_BINARY) {
            byte[] copy = new byte[this.scratch.length - SimpleTextStoredFieldsWriter.VALUE.length];
            System.arraycopy(this.scratch.bytes, this.scratch.offset + SimpleTextStoredFieldsWriter.VALUE.length, copy, 0, copy.length);
            visitor.binaryField(fieldInfo, copy);
        } else if (type == SimpleTextStoredFieldsWriter.TYPE_INT) {
            UnicodeUtil.UTF8toUTF16((byte[])this.scratch.bytes, (int)(this.scratch.offset + SimpleTextStoredFieldsWriter.VALUE.length), (int)(this.scratch.length - SimpleTextStoredFieldsWriter.VALUE.length), (CharsRef)this.scratchUTF16);
            visitor.intField(fieldInfo, Integer.parseInt(this.scratchUTF16.toString()));
        } else if (type == SimpleTextStoredFieldsWriter.TYPE_LONG) {
            UnicodeUtil.UTF8toUTF16((byte[])this.scratch.bytes, (int)(this.scratch.offset + SimpleTextStoredFieldsWriter.VALUE.length), (int)(this.scratch.length - SimpleTextStoredFieldsWriter.VALUE.length), (CharsRef)this.scratchUTF16);
            visitor.longField(fieldInfo, Long.parseLong(this.scratchUTF16.toString()));
        } else if (type == SimpleTextStoredFieldsWriter.TYPE_FLOAT) {
            UnicodeUtil.UTF8toUTF16((byte[])this.scratch.bytes, (int)(this.scratch.offset + SimpleTextStoredFieldsWriter.VALUE.length), (int)(this.scratch.length - SimpleTextStoredFieldsWriter.VALUE.length), (CharsRef)this.scratchUTF16);
            visitor.floatField(fieldInfo, Float.parseFloat(this.scratchUTF16.toString()));
        } else if (type == SimpleTextStoredFieldsWriter.TYPE_DOUBLE) {
            UnicodeUtil.UTF8toUTF16((byte[])this.scratch.bytes, (int)(this.scratch.offset + SimpleTextStoredFieldsWriter.VALUE.length), (int)(this.scratch.length - SimpleTextStoredFieldsWriter.VALUE.length), (CharsRef)this.scratchUTF16);
            visitor.doubleField(fieldInfo, Double.parseDouble(this.scratchUTF16.toString()));
        }
    }

    public StoredFieldsReader clone() {
        if (this.in == null) {
            throw new AlreadyClosedException("this FieldsReader is closed");
        }
        return new SimpleTextStoredFieldsReader(this.offsets, this.in.clone(), this.fieldInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            IOUtils.close((Closeable[])new Closeable[]{this.in});
        }
        finally {
            this.in = null;
            this.offsets = null;
        }
    }

    private void readLine() throws IOException {
        SimpleTextUtil.readLine((DataInput)this.in, this.scratch);
    }

    private int parseIntAt(int offset) {
        UnicodeUtil.UTF8toUTF16((byte[])this.scratch.bytes, (int)(this.scratch.offset + offset), (int)(this.scratch.length - offset), (CharsRef)this.scratchUTF16);
        return ArrayUtil.parseInt((char[])this.scratchUTF16.chars, (int)0, (int)this.scratchUTF16.length);
    }

    private boolean equalsAt(BytesRef a, BytesRef b, int bOffset) {
        return a.length == b.length - bOffset && ArrayUtil.equals((byte[])a.bytes, (int)a.offset, (byte[])b.bytes, (int)(b.offset + bOffset), (int)(b.length - bOffset));
    }

    public long ramBytesUsed() {
        return 0L;
    }

    public void checkIntegrity() throws IOException {
    }
}

