/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.geo;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import com.carrotsearch.randomizedtesting.generators.BiasedNumbers;
import java.util.ArrayList;
import java.util.Random;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.XYCircle;
import org.apache.lucene.geo.XYEncodingUtils;
import org.apache.lucene.geo.XYLine;
import org.apache.lucene.geo.XYPoint;
import org.apache.lucene.geo.XYPolygon;
import org.apache.lucene.geo.XYRectangle;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.TestUtil;

public class ShapeTestUtil {
    public static XYPolygon nextPolygon() {
        Random random = ShapeTestUtil.random();
        if (random.nextBoolean()) {
            return ShapeTestUtil.surpriseMePolygon(random);
        }
        if (LuceneTestCase.TEST_NIGHTLY && random.nextInt(10) == 1) {
            while (true) {
                int gons = TestUtil.nextInt(random, 4, 500);
                double radius = random.nextDouble() * 0.5 * 3.4028234663852886E38 + 1.0;
                try {
                    return ShapeTestUtil.createRegularPolygon(ShapeTestUtil.nextFloat(random), ShapeTestUtil.nextFloat(random), radius, gons);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
                break;
            }
        }
        XYRectangle box = ShapeTestUtil.nextBox(random);
        if (random.nextBoolean()) {
            return ShapeTestUtil.boxPolygon(box);
        }
        return ShapeTestUtil.trianglePolygon(box);
    }

    public static XYPoint nextPoint() {
        Random random = ShapeTestUtil.random();
        float x = ShapeTestUtil.nextFloat(random);
        float y = ShapeTestUtil.nextFloat(random);
        return new XYPoint(x, y);
    }

    public static XYLine nextLine() {
        XYPolygon poly = ShapeTestUtil.nextPolygon();
        float[] x = new float[poly.numPoints() - 1];
        float[] y = new float[x.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = poly.getPolyX(i);
            y[i] = poly.getPolyY(i);
        }
        return new XYLine(x, y);
    }

    public static XYCircle nextCircle() {
        Random random = ShapeTestUtil.random();
        float x = ShapeTestUtil.nextFloat(random);
        float y = ShapeTestUtil.nextFloat(random);
        float radius = 0.0f;
        while (radius == 0.0f) {
            radius = ShapeTestUtil.random().nextFloat() * Float.MAX_VALUE / 2.0f;
        }
        assert (radius != 0.0f);
        return new XYCircle(x, y, radius);
    }

    private static XYPolygon trianglePolygon(XYRectangle box) {
        float[] polyX = new float[4];
        float[] polyY = new float[4];
        polyX[0] = box.minX;
        polyY[0] = box.minY;
        polyX[1] = box.maxX;
        polyY[1] = box.minY;
        polyX[2] = box.maxX;
        polyY[2] = box.maxY;
        polyX[3] = box.minX;
        polyY[3] = box.minY;
        return new XYPolygon(polyX, polyY, new XYPolygon[0]);
    }

    public static XYRectangle nextBox(Random random) {
        float x0 = ShapeTestUtil.nextFloat(random);
        float x1 = ShapeTestUtil.nextFloat(random);
        while (x0 == x1) {
            x1 = ShapeTestUtil.nextFloat(random);
        }
        float y0 = ShapeTestUtil.nextFloat(random);
        float y1 = ShapeTestUtil.nextFloat(random);
        while (y0 == y1) {
            y1 = ShapeTestUtil.nextFloat(random);
        }
        if (x1 < x0) {
            float x = x0;
            x0 = x1;
            x1 = x;
        }
        if (y1 < y0) {
            float y = y0;
            y0 = y1;
            y1 = y;
        }
        return new XYRectangle(x0, x1, y0, y1);
    }

    private static XYPolygon boxPolygon(XYRectangle box) {
        float[] polyX = new float[5];
        float[] polyY = new float[5];
        polyX[0] = box.minX;
        polyY[0] = box.minY;
        polyX[1] = box.maxX;
        polyY[1] = box.minY;
        polyX[2] = box.maxX;
        polyY[2] = box.maxY;
        polyX[3] = box.minX;
        polyY[3] = box.maxY;
        polyX[4] = box.minX;
        polyY[4] = box.minY;
        return new XYPolygon(polyX, polyY, new XYPolygon[0]);
    }

    private static XYPolygon surpriseMePolygon(Random random) {
        float centerX = ShapeTestUtil.nextFloat(random);
        float centerY = ShapeTestUtil.nextFloat(random);
        double radius = 0.1 + 20.0 * random.nextDouble();
        double radiusDelta = random.nextDouble();
        ArrayList<Float> xList = new ArrayList<Float>();
        ArrayList<Float> yList = new ArrayList<Float>();
        double angle = 0.0;
        while (!((angle += random.nextDouble() * 40.0) > 360.0)) {
            double len = radius * (1.0 - radiusDelta + radiusDelta * random.nextDouble());
            float maxX = StrictMath.min(StrictMath.abs(Float.MAX_VALUE - centerX), StrictMath.abs(-3.4028235E38f - centerX));
            float maxY = StrictMath.min(StrictMath.abs(Float.MAX_VALUE - centerY), StrictMath.abs(-3.4028235E38f - centerY));
            len = StrictMath.min(len, (double)StrictMath.min(maxX, maxY));
            float x = (float)((double)centerX + len * Math.cos(Math.toRadians(angle)));
            float y = (float)((double)centerY + len * Math.sin(Math.toRadians(angle)));
            xList.add(Float.valueOf(x));
            yList.add(Float.valueOf(y));
        }
        xList.add((Float)xList.get(0));
        yList.add((Float)yList.get(0));
        float[] xArray = new float[xList.size()];
        float[] yArray = new float[yList.size()];
        for (int i = 0; i < xList.size(); ++i) {
            xArray[i] = ((Float)xList.get(i)).floatValue();
            yArray[i] = ((Float)yList.get(i)).floatValue();
        }
        return new XYPolygon(xArray, yArray, new XYPolygon[0]);
    }

    public static XYPolygon createRegularPolygon(double centerX, double centerY, double radius, int gons) {
        double maxX = StrictMath.min(StrictMath.abs(3.4028234663852886E38 - centerX), StrictMath.abs(-3.4028234663852886E38 - centerX));
        double maxY = StrictMath.min(StrictMath.abs(3.4028234663852886E38 - centerY), StrictMath.abs(-3.4028234663852886E38 - centerY));
        radius = StrictMath.min(radius, StrictMath.min(maxX, maxY));
        float[][] result = new float[][]{new float[gons + 1], new float[gons + 1]};
        for (int i = 0; i < gons; ++i) {
            double angle = 360.0 - (double)i * (360.0 / (double)gons);
            double x = Math.cos(StrictMath.toRadians(angle));
            double y = Math.sin(StrictMath.toRadians(angle));
            result[0][i] = (float)(centerY + y * radius);
            result[1][i] = (float)(centerX + x * radius);
        }
        result[0][gons] = result[0][0];
        result[1][gons] = result[1][0];
        return new XYPolygon(result[0], result[1], new XYPolygon[0]);
    }

    public static float nextFloat(Random random) {
        return BiasedNumbers.randomFloatBetween((Random)random, (float)-3.4028235E38f, (float)Float.MAX_VALUE);
    }

    private static Random random() {
        return RandomizedContext.current().getRandom();
    }

    public static boolean containsSlowly(XYPolygon polygon, double x, double y) {
        if (polygon.getHoles().length > 0) {
            throw new UnsupportedOperationException("this testing method does not support holes");
        }
        double[] polyXs = XYEncodingUtils.floatArrayToDoubleArray((float[])polygon.getPolyX());
        double[] polyYs = XYEncodingUtils.floatArrayToDoubleArray((float[])polygon.getPolyY());
        if (x < (double)polygon.minX || x > (double)polygon.maxX || y < (double)polygon.minY || y > (double)polygon.maxY) {
            return false;
        }
        boolean c = false;
        int nvert = polyYs.length;
        double[] verty = polyYs;
        double[] vertx = polyXs;
        double testy = y;
        double testx = x;
        int i = 0;
        for (int j = 1; j < nvert; ++j) {
            if (testy == verty[j] && testy == verty[i] || (testy <= verty[j] && testy >= verty[i]) != (testy >= verty[j] && testy <= verty[i])) {
                if (testx == vertx[j] && testx == vertx[i] || (testx <= vertx[j] && testx >= vertx[i]) != (testx >= vertx[j] && testx <= vertx[i]) && GeoUtils.orient((double)vertx[i], (double)verty[i], (double)vertx[j], (double)verty[j], (double)testx, (double)testy) == 0) {
                    return true;
                }
                if (verty[i] > testy != verty[j] > testy && testx < (vertx[j] - vertx[i]) * (testy - verty[i]) / (verty[j] - verty[i]) + vertx[i]) {
                    c = !c;
                }
            }
            ++i;
        }
        return c;
    }
}

