/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;

@Experimental
public enum Scope {
    EMPTY(""),
    COMPILE_ONLY("compile-only"),
    COMPILE("compile"),
    RUNTIME("runtime"),
    PROVIDED("provided"),
    TEST_COMPILE_ONLY("test-compile-only"),
    TEST("test"),
    TEST_RUNTIME("test-runtime"),
    IMPORT("import");

    private final String id;
    private static final Map<String, Scope> SCOPES;

    private Scope(String id) {
        this.id = id;
    }

    public String id() {
        return this.id;
    }

    public static Scope get(String scope) {
        return SCOPES.get(scope);
    }

    static {
        HashMap<String, Scope> scopes = new HashMap<String, Scope>();
        for (Scope s : Scope.values()) {
            scopes.put(s.id, s);
        }
        SCOPES = scopes;
    }
}

