/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.maven.api.Dependency;
import org.apache.maven.api.NodeVisitor;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;

@Experimental
@Immutable
public interface Node {
    public Dependency getDependency();

    @Nonnull
    public List<Node> getChildren();

    @Nonnull
    public List<RemoteRepository> getRemoteRepositories();

    @Nonnull
    public Optional<RemoteRepository> getRepository();

    public boolean accept(@Nonnull NodeVisitor var1);

    public Node filter(Predicate<Node> var1);

    public String asString();

    @Nonnull
    default public Stream<Node> stream() {
        return Stream.concat(Stream.of(this), this.getChildren().stream().flatMap(Node::stream));
    }
}

