/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.util.Collection;
import java.util.List;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.DependencyCoordinate;
import org.apache.maven.api.Project;
import org.apache.maven.api.ResolutionScope;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.DependencyCollectorRequest;

@Experimental
public interface DependencyResolverRequest
extends DependencyCollectorRequest {
    @Nonnull
    public ResolutionScope getResolutionScope();

    @Nonnull
    public static DependencyResolverRequestBuilder builder() {
        return new DependencyResolverRequestBuilder();
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, Project project) {
        return DependencyResolverRequest.build(session, project, ResolutionScope.PROJECT_RUNTIME);
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, Project project, ResolutionScope scope) {
        return new DependencyResolverRequestBuilder().session(session).project(project).resolutionScope(scope).build();
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, DependencyCoordinate dependency) {
        return DependencyResolverRequest.build(session, dependency, ResolutionScope.PROJECT_RUNTIME);
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, DependencyCoordinate dependency, ResolutionScope scope) {
        return new DependencyResolverRequestBuilder().session(session).dependency(dependency).resolutionScope(scope).build();
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, List<DependencyCoordinate> dependencies) {
        return DependencyResolverRequest.build(session, dependencies, ResolutionScope.PROJECT_RUNTIME);
    }

    @Nonnull
    public static DependencyResolverRequest build(Session session, List<DependencyCoordinate> dependencies, ResolutionScope scope) {
        return ((DependencyResolverRequestBuilder)new DependencyResolverRequestBuilder().session(session).dependencies((List)dependencies)).resolutionScope(scope).build();
    }

    @NotThreadSafe
    public static class DependencyResolverRequestBuilder
    extends DependencyCollectorRequest.DependencyCollectorRequestBuilder {
        ResolutionScope resolutionScope;

        @Override
        @Nonnull
        public DependencyResolverRequestBuilder session(@Nonnull Session session) {
            super.session(session);
            return this;
        }

        @Override
        @Nonnull
        public DependencyResolverRequestBuilder project(@Nullable Project project) {
            super.project(project);
            return this;
        }

        @Override
        @Nonnull
        public DependencyResolverRequestBuilder rootArtifact(@Nullable Artifact rootArtifact) {
            super.rootArtifact(rootArtifact);
            return this;
        }

        @Override
        @Nonnull
        public DependencyResolverRequestBuilder root(@Nullable DependencyCoordinate root) {
            super.root(root);
            return this;
        }

        @Override
        @Nonnull
        public DependencyResolverRequestBuilder dependencies(@Nullable List<DependencyCoordinate> dependencies) {
            super.dependencies(dependencies);
            return this;
        }

        @Override
        @Nonnull
        public DependencyResolverRequestBuilder dependency(@Nullable DependencyCoordinate dependency) {
            super.dependency(dependency);
            return this;
        }

        @Override
        @Nonnull
        public DependencyResolverRequestBuilder managedDependencies(@Nullable List<DependencyCoordinate> managedDependencies) {
            super.managedDependencies(managedDependencies);
            return this;
        }

        @Override
        @Nonnull
        public DependencyResolverRequestBuilder managedDependency(@Nullable DependencyCoordinate managedDependency) {
            super.managedDependency(managedDependency);
            return this;
        }

        @Override
        @Nonnull
        public DependencyResolverRequestBuilder verbose(boolean verbose) {
            super.verbose(verbose);
            return this;
        }

        @Nonnull
        public DependencyResolverRequestBuilder resolutionScope(@Nonnull ResolutionScope resolutionScope) {
            this.resolutionScope = resolutionScope;
            return this;
        }

        @Override
        public DependencyResolverRequest build() {
            return new DefaultDependencyResolverRequest(this.session, this.project, this.rootArtifact, this.root, this.dependencies, this.managedDependencies, this.verbose, this.resolutionScope);
        }

        static class DefaultDependencyResolverRequest
        extends DependencyCollectorRequest.DependencyCollectorRequestBuilder.DefaultDependencyCollectorRequest
        implements DependencyResolverRequest {
            private final ResolutionScope resolutionScope;

            DefaultDependencyResolverRequest(Session session, Project project, Artifact rootArtifact, DependencyCoordinate root, Collection<DependencyCoordinate> dependencies, Collection<DependencyCoordinate> managedDependencies, boolean verbose, ResolutionScope resolutionScope) {
                super(session, project, rootArtifact, root, dependencies, managedDependencies, verbose);
                this.resolutionScope = DefaultDependencyResolverRequest.nonNull(resolutionScope, "resolutionScope cannot be null");
                if (verbose) {
                    throw new IllegalArgumentException("verbose cannot be true for resolving dependencies");
                }
            }

            @Override
            @Nonnull
            public ResolutionScope getResolutionScope() {
                return this.resolutionScope;
            }
        }
    }
}

