// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * The {@code <build>} element contains information required to build the project.
 * Default values are defined in Super POM.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Build
    extends BuildBase
    implements Serializable, InputLocationTracker
{
    /**
     * All the sources to compile and resources files to copy for a project or it's unit tests.
     * The sources can be Java source files, generated source files, scripts or resources for examples.
     * Each source is specified by a mandatory {@code directory} element, which is relative to the POM.
     * The kind of sources (codes to compile or resources to copy) and their usage (for the main code
     * or for the tests) is specified by the {@code scope} element together with each source directory.
     */
    final List<Source> sources;
    /**
     * This element specifies a directory containing the source of the project. The
     * generated build system will compile the sources from this directory when the project is
     * built. The path given is relative to the project descriptor.
     * The default value is {@code src/main/java}.
     * 
     * @deprecated Replaced by {@code <Source>} with {@code main} scope.
     */
    @Deprecated(since = "4.0.0")
    final String sourceDirectory;
    /**
     * This element specifies a directory containing the script sources of the
     * project. This directory is meant to be different from the sourceDirectory, in that its
     * contents will be copied to the output directory in most cases (since scripts are
     * interpreted rather than compiled).
     * The default value is {@code src/main/scripts}.
     * 
     * @deprecated Replaced by {@code <Source>} with {@code script} language.
     */
    @Deprecated(since = "4.0.0")
    final String scriptSourceDirectory;
    /**
     * This element specifies a directory containing the unit test source of the
     * project. The generated build system will compile these directories when the project is
     * being tested. The path given is relative to the project descriptor.
     * The default value is {@code src/test/java}.
     * 
     * @deprecated Replaced by {@code <Source>} with {@code test} scope.
     */
    @Deprecated(since = "4.0.0")
    final String testSourceDirectory;
    /**
     * The directory where compiled application classes are placed.
     * The default value is {@code target/classes}.
     */
    final String outputDirectory;
    /**
     * The directory where compiled test classes are placed.
     * The default value is {@code target/test-classes}.
     */
    final String testOutputDirectory;
    /**
     * A set of build extensions to use from this project.
     */
    final List<Extension> extensions;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected Build(Builder builder) {
        super(builder);
        this.sources = ImmutableCollections.copy(builder.sources != null ? builder.sources : (builder.base != null ? builder.base.sources : null));
        this.sourceDirectory = builder.sourceDirectory != null ? builder.sourceDirectory : (builder.base != null ? builder.base.sourceDirectory : null);
        this.scriptSourceDirectory = builder.scriptSourceDirectory != null ? builder.scriptSourceDirectory : (builder.base != null ? builder.base.scriptSourceDirectory : null);
        this.testSourceDirectory = builder.testSourceDirectory != null ? builder.testSourceDirectory : (builder.base != null ? builder.base.testSourceDirectory : null);
        this.outputDirectory = builder.outputDirectory != null ? builder.outputDirectory : (builder.base != null ? builder.base.outputDirectory : null);
        this.testOutputDirectory = builder.testOutputDirectory != null ? builder.testOutputDirectory : (builder.base != null ? builder.base.testOutputDirectory : null);
        this.extensions = ImmutableCollections.copy(builder.extensions != null ? builder.extensions : (builder.base != null ? builder.base.extensions : null));
    }

    /**
     * All the sources to compile and resources files to copy for a project or it's unit tests.
     * The sources can be Java source files, generated source files, scripts or resources for examples.
     * Each source is specified by a mandatory {@code directory} element, which is relative to the POM.
     * The kind of sources (codes to compile or resources to copy) and their usage (for the main code
     * or for the tests) is specified by the {@code scope} element together with each source directory.
     *
     * @return a {@code List<Source>}
     */
    @Nonnull
    public List<Source> getSources() {
        return this.sources;
    }

    /**
     * This element specifies a directory containing the source of the project. The
     * generated build system will compile the sources from this directory when the project is
     * built. The path given is relative to the project descriptor.
     * The default value is {@code src/main/java}.
     * 
     * @deprecated Replaced by {@code <Source>} with {@code main} scope.
     *
     * @return a {@code String}
     */
    @Deprecated(since = "4.0.0")
    public String getSourceDirectory() {
        return this.sourceDirectory;
    }

    /**
     * This element specifies a directory containing the script sources of the
     * project. This directory is meant to be different from the sourceDirectory, in that its
     * contents will be copied to the output directory in most cases (since scripts are
     * interpreted rather than compiled).
     * The default value is {@code src/main/scripts}.
     * 
     * @deprecated Replaced by {@code <Source>} with {@code script} language.
     *
     * @return a {@code String}
     */
    @Deprecated(since = "4.0.0")
    public String getScriptSourceDirectory() {
        return this.scriptSourceDirectory;
    }

    /**
     * This element specifies a directory containing the unit test source of the
     * project. The generated build system will compile these directories when the project is
     * being tested. The path given is relative to the project descriptor.
     * The default value is {@code src/test/java}.
     * 
     * @deprecated Replaced by {@code <Source>} with {@code test} scope.
     *
     * @return a {@code String}
     */
    @Deprecated(since = "4.0.0")
    public String getTestSourceDirectory() {
        return this.testSourceDirectory;
    }

    /**
     * The directory where compiled application classes are placed.
     * The default value is {@code target/classes}.
     *
     * @return a {@code String}
     */
    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    /**
     * The directory where compiled test classes are placed.
     * The default value is {@code target/test-classes}.
     *
     * @return a {@code String}
     */
    public String getTestOutputDirectory() {
        return this.testOutputDirectory;
    }

    /**
     * A set of build extensions to use from this project.
     *
     * @return a {@code List<Extension>}
     */
    @Nonnull
    public List<Extension> getExtensions() {
        return this.extensions;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Build} instance using the specified plugins.
     *
     * @param plugins the new {@code Collection<Plugin>} to use
     * @return a {@code Build} with the specified plugins
     */
    @Nonnull
    public Build withPlugins(Collection<Plugin> plugins) {
        return newBuilder(this, true).plugins(plugins).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified pluginManagement.
     *
     * @param pluginManagement the new {@code PluginManagement} to use
     * @return a {@code Build} with the specified pluginManagement
     */
    @Nonnull
    public Build withPluginManagement(PluginManagement pluginManagement) {
        return newBuilder(this, true).pluginManagement(pluginManagement).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified defaultGoal.
     *
     * @param defaultGoal the new {@code String} to use
     * @return a {@code Build} with the specified defaultGoal
     */
    @Nonnull
    public Build withDefaultGoal(String defaultGoal) {
        return newBuilder(this, true).defaultGoal(defaultGoal).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified resources.
     *
     * @param resources the new {@code Collection<Resource>} to use
     * @return a {@code Build} with the specified resources
     */
    @Deprecated(since = "4.0.0")
    @Nonnull
    public Build withResources(Collection<Resource> resources) {
        return newBuilder(this, true).resources(resources).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified testResources.
     *
     * @param testResources the new {@code Collection<Resource>} to use
     * @return a {@code Build} with the specified testResources
     */
    @Deprecated(since = "4.0.0")
    @Nonnull
    public Build withTestResources(Collection<Resource> testResources) {
        return newBuilder(this, true).testResources(testResources).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified directory.
     *
     * @param directory the new {@code String} to use
     * @return a {@code Build} with the specified directory
     */
    @Nonnull
    public Build withDirectory(String directory) {
        return newBuilder(this, true).directory(directory).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified finalName.
     *
     * @param finalName the new {@code String} to use
     * @return a {@code Build} with the specified finalName
     */
    @Nonnull
    public Build withFinalName(String finalName) {
        return newBuilder(this, true).finalName(finalName).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified filters.
     *
     * @param filters the new {@code Collection<String>} to use
     * @return a {@code Build} with the specified filters
     */
    @Nonnull
    public Build withFilters(Collection<String> filters) {
        return newBuilder(this, true).filters(filters).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified sources.
     *
     * @param sources the new {@code Collection<Source>} to use
     * @return a {@code Build} with the specified sources
     */
    @Nonnull
    public Build withSources(Collection<Source> sources) {
        return newBuilder(this, true).sources(sources).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified sourceDirectory.
     *
     * @param sourceDirectory the new {@code String} to use
     * @return a {@code Build} with the specified sourceDirectory
     */
    @Deprecated(since = "4.0.0")
    @Nonnull
    public Build withSourceDirectory(String sourceDirectory) {
        return newBuilder(this, true).sourceDirectory(sourceDirectory).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified scriptSourceDirectory.
     *
     * @param scriptSourceDirectory the new {@code String} to use
     * @return a {@code Build} with the specified scriptSourceDirectory
     */
    @Deprecated(since = "4.0.0")
    @Nonnull
    public Build withScriptSourceDirectory(String scriptSourceDirectory) {
        return newBuilder(this, true).scriptSourceDirectory(scriptSourceDirectory).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified testSourceDirectory.
     *
     * @param testSourceDirectory the new {@code String} to use
     * @return a {@code Build} with the specified testSourceDirectory
     */
    @Deprecated(since = "4.0.0")
    @Nonnull
    public Build withTestSourceDirectory(String testSourceDirectory) {
        return newBuilder(this, true).testSourceDirectory(testSourceDirectory).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified outputDirectory.
     *
     * @param outputDirectory the new {@code String} to use
     * @return a {@code Build} with the specified outputDirectory
     */
    @Nonnull
    public Build withOutputDirectory(String outputDirectory) {
        return newBuilder(this, true).outputDirectory(outputDirectory).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified testOutputDirectory.
     *
     * @param testOutputDirectory the new {@code String} to use
     * @return a {@code Build} with the specified testOutputDirectory
     */
    @Nonnull
    public Build withTestOutputDirectory(String testOutputDirectory) {
        return newBuilder(this, true).testOutputDirectory(testOutputDirectory).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified extensions.
     *
     * @param extensions the new {@code Collection<Extension>} to use
     * @return a {@code Build} with the specified extensions
     */
    @Nonnull
    public Build withExtensions(Collection<Extension> extensions) {
        return newBuilder(this, true).extensions(extensions).build();
    }

    /**
     * Creates a new {@code Build} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Build}
     */
    @Nonnull
    public static Build newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Build} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Build}
     */
    @Nonnull
    public static Build newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Build} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Build} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Build} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Build} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Build from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Build} builder instance using the specified object as a basis.
     *
     * @param from the {@code Build} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Build from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Build instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends BuildBase.Builder
    {
        Build base;
        Collection<Source> sources;
        String sourceDirectory;
        String scriptSourceDirectory;
        String testSourceDirectory;
        String outputDirectory;
        String testOutputDirectory;
        Collection<Extension> extensions;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
            }
        }

        protected Builder(Build base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.sources = base.sources;
                this.sourceDirectory = base.sourceDirectory;
                this.scriptSourceDirectory = base.scriptSourceDirectory;
                this.testSourceDirectory = base.testSourceDirectory;
                this.outputDirectory = base.outputDirectory;
                this.testOutputDirectory = base.testOutputDirectory;
                this.extensions = base.extensions;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder plugins(Collection<Plugin> plugins) {
            this.plugins = plugins;
            return this;
        }

        @Nonnull
        public Builder pluginManagement(PluginManagement pluginManagement) {
            this.pluginManagement = pluginManagement;
            return this;
        }

        @Nonnull
        public Builder defaultGoal(String defaultGoal) {
            this.defaultGoal = defaultGoal;
            return this;
        }

        @Deprecated(since = "4.0.0")
        @Nonnull
        public Builder resources(Collection<Resource> resources) {
            this.resources = resources;
            return this;
        }

        @Deprecated(since = "4.0.0")
        @Nonnull
        public Builder testResources(Collection<Resource> testResources) {
            this.testResources = testResources;
            return this;
        }

        @Nonnull
        public Builder directory(String directory) {
            this.directory = directory;
            return this;
        }

        @Nonnull
        public Builder finalName(String finalName) {
            this.finalName = finalName;
            return this;
        }

        @Nonnull
        public Builder filters(Collection<String> filters) {
            this.filters = filters;
            return this;
        }

        @Nonnull
        public Builder sources(Collection<Source> sources) {
            this.sources = sources;
            return this;
        }

        @Deprecated(since = "4.0.0")
        @Nonnull
        public Builder sourceDirectory(String sourceDirectory) {
            this.sourceDirectory = sourceDirectory;
            return this;
        }

        @Deprecated(since = "4.0.0")
        @Nonnull
        public Builder scriptSourceDirectory(String scriptSourceDirectory) {
            this.scriptSourceDirectory = scriptSourceDirectory;
            return this;
        }

        @Deprecated(since = "4.0.0")
        @Nonnull
        public Builder testSourceDirectory(String testSourceDirectory) {
            this.testSourceDirectory = testSourceDirectory;
            return this;
        }

        @Nonnull
        public Builder outputDirectory(String outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        @Nonnull
        public Builder testOutputDirectory(String testOutputDirectory) {
            this.testOutputDirectory = testOutputDirectory;
            return this;
        }

        @Nonnull
        public Builder extensions(Collection<Extension> extensions) {
            this.extensions = extensions;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public Build build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (plugins == null || plugins == base.plugins)
                    && (pluginManagement == null || pluginManagement == base.pluginManagement)
                    && (defaultGoal == null || defaultGoal == base.defaultGoal)
                    && (resources == null || resources == base.resources)
                    && (testResources == null || testResources == base.testResources)
                    && (directory == null || directory == base.directory)
                    && (finalName == null || finalName == base.finalName)
                    && (filters == null || filters == base.filters)
                    && (sources == null || sources == base.sources)
                    && (sourceDirectory == null || sourceDirectory == base.sourceDirectory)
                    && (scriptSourceDirectory == null || scriptSourceDirectory == base.scriptSourceDirectory)
                    && (testSourceDirectory == null || testSourceDirectory == base.testSourceDirectory)
                    && (outputDirectory == null || outputDirectory == base.outputDirectory)
                    && (testOutputDirectory == null || testOutputDirectory == base.testOutputDirectory)
                    && (extensions == null || extensions == base.extensions)
            ) {
                return base;
            }
            return new Build(this);
        }

    }


            
    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return "Build {" + super.toString() + "}";
    }
            
          
}
