/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class AnalyzeDepMgt
extends AbstractMojo {
    private MavenProject project;
    private boolean failBuild = false;
    private boolean ignoreDirect = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean result = this.checkDependencyManagement();
        if (result) {
            if (this.failBuild) {
                throw new MojoExecutionException("Found Dependency errors.");
            }
            this.getLog().warn((CharSequence)"Potential problems found in Dependency Management ");
        }
    }

    private boolean checkDependencyManagement() throws MojoExecutionException {
        boolean foundMismatch = false;
        this.getLog().info((CharSequence)"Found Resolved Dependency / DependencyManagement mismatches:");
        List depMgtDependencies = null;
        DependencyManagement depMgt = this.project.getDependencyManagement();
        if (depMgt != null) {
            depMgtDependencies = depMgt.getDependencies();
        }
        if (depMgtDependencies != null && !depMgtDependencies.isEmpty()) {
            HashMap<String, Dependency> map = new HashMap<String, Dependency>();
            Iterator iter = depMgtDependencies.iterator();
            while (iter.hasNext()) {
                Dependency dependency = (Dependency)iter.next();
                map.put(dependency.getManagementKey(), dependency);
            }
            Set allDependencies = this.project.getArtifacts();
            if (this.ignoreDirect) {
                this.getLog().info((CharSequence)"\tIgnoring Direct Dependencies.");
                Set directDependencies = this.project.getDependencyArtifacts();
                allDependencies.removeAll(directDependencies);
            }
            iter = allDependencies.iterator();
            while (iter.hasNext()) {
                Artifact artifact = (Artifact)iter.next();
                Dependency dep = (Dependency)map.get(this.getArtifactManagementKey(artifact));
                if (dep == null) continue;
                DefaultArtifactVersion artifactVersion = new DefaultArtifactVersion(artifact.getVersion());
                if (artifact.isSnapshot() || dep.getVersion().equals(artifact.getVersion())) continue;
                this.logMismatch(artifact, dep);
                foundMismatch = true;
            }
        } else {
            this.getLog().info((CharSequence)"   Nothing in DepMgt.");
        }
        if (!foundMismatch) {
            this.getLog().info((CharSequence)"   None");
        }
        return foundMismatch;
    }

    private void logMismatch(Artifact artifact, Dependency dependency) throws MojoExecutionException {
        if (artifact == null || dependency == null) {
            throw new MojoExecutionException("Invalid params: Artifact:" + artifact + " Dependency:" + dependency);
        }
        this.getLog().info((CharSequence)("\tDependency: " + dependency.getManagementKey()));
        this.getLog().info((CharSequence)("\t\tDepMgt  : " + artifact.getVersion()));
        this.getLog().info((CharSequence)("\t\tResolved: " + dependency.getVersion()));
    }

    private String getArtifactManagementKey(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + (!StringUtils.isEmpty((String)artifact.getClassifier()) ? ":" + artifact.getClassifier() : "");
    }

    public boolean isFailBuild() {
        return this.failBuild;
    }

    public void setFailBuild(boolean theFailBuild) {
        this.failBuild = theFailBuild;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject theProject) {
        this.project = theProject;
    }

    public boolean isIgnoreDirect() {
        return this.ignoreDirect;
    }

    public void setIgnoreDirect(boolean theIgnoreDirect) {
        this.ignoreDirect = theIgnoreDirect;
    }
}

