/*
 * $Id$
 */

package org.apache.maven.plugin.javadoc.options;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * A Group parameter.
 * 
 * @version $Revision$ $Date$
 */
public class Group implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field title
     */
    private String title;

    /**
     * Field packages
     */
    private String packages;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals
     * 
     * @param other
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof Group) )
        {
            return false;
        }
        
        Group that = (Group) other;
        boolean result = true;
        result = result && ( getTitle() == null ? that.getTitle() == null : getTitle().equals( that.getTitle() ) );
        result = result && ( getPackages() == null ? that.getPackages() == null : getPackages().equals( that.getPackages() ) );
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get Packages can be any package name, or can be the start of
     * any package name followed by an asterisk (*). The asterisk
     * is a wildcard meaning "match any characters". This is the
     * only wildcard allowed. Multiple patterns can be included in
     * a group by separating them with colons (:).
     */
    public String getPackages()
    {
        return this.packages;
    } //-- String getPackages() 

    /**
     * Get Title can be any text, and can include white space. This
     * text is placed in the table heading for the group.
     */
    public String getTitle()
    {
        return this.title;
    } //-- String getTitle() 

    /**
     * Method hashCode
     */
    public int hashCode()
    {
        int result = 17;
        long tmp;
        result = 37 * result + ( title != null ? title.hashCode() : 0 );
        result = 37 * result + ( packages != null ? packages.hashCode() : 0 );
        return result;
    } //-- int hashCode() 

    /**
     * Set Packages can be any package name, or can be the start of
     * any package name followed by an asterisk (*). The asterisk
     * is a wildcard meaning "match any characters". This is the
     * only wildcard allowed. Multiple patterns can be included in
     * a group by separating them with colons (:).
     * 
     * @param packages
     */
    public void setPackages(String packages)
    {
        this.packages = packages;
    } //-- void setPackages(String) 

    /**
     * Set Title can be any text, and can include white space. This
     * text is placed in the table heading for the group.
     * 
     * @param title
     */
    public void setTitle(String title)
    {
        this.title = title;
    } //-- void setTitle(String) 

    /**
     * Method toString
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        buf.append( "title = '" );
        buf.append( getTitle() + "'" );
        buf.append( "\n" ); 
        buf.append( "packages = '" );
        buf.append( getPackages() + "'" );
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
