/*
 * $Id$
 */

package org.apache.maven.plugin.javadoc.options;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * An artifact object used by Javadoc path options like -docletpath
 * or -tagletpath.
 * 
 * @version $Revision$ $Date$
 */
public class JavadocPathArtifact implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field groupId
     */
    private String groupId;

    /**
     * Field artifactId
     */
    private String artifactId;

    /**
     * Field version
     */
    private String version;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals
     * 
     * @param other
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof JavadocPathArtifact) )
        {
            return false;
        }
        
        JavadocPathArtifact that = (JavadocPathArtifact) other;
        boolean result = true;
        result = result && ( getGroupId() == null ? that.getGroupId() == null : getGroupId().equals( that.getGroupId() ) );
        result = result && ( getArtifactId() == null ? that.getArtifactId() == null : getArtifactId().equals( that.getArtifactId() ) );
        result = result && ( getVersion() == null ? that.getVersion() == null : getVersion().equals( that.getVersion() ) );
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get The id of the artifact.
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Get The id of the group of the artifact.
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Get The version of the artifact.
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Method hashCode
     */
    public int hashCode()
    {
        int result = 17;
        long tmp;
        result = 37 * result + ( groupId != null ? groupId.hashCode() : 0 );
        result = 37 * result + ( artifactId != null ? artifactId.hashCode() : 0 );
        result = 37 * result + ( version != null ? version.hashCode() : 0 );
        return result;
    } //-- int hashCode() 

    /**
     * Set The id of the artifact.
     * 
     * @param artifactId
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId(String) 

    /**
     * Set The id of the group of the artifact.
     * 
     * @param groupId
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    } //-- void setGroupId(String) 

    /**
     * Set The version of the artifact.
     * 
     * @param version
     */
    public void setVersion(String version)
    {
        this.version = version;
    } //-- void setVersion(String) 

    /**
     * Method toString
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        buf.append( "groupId = '" );
        buf.append( getGroupId() + "'" );
        buf.append( "\n" ); 
        buf.append( "artifactId = '" );
        buf.append( getArtifactId() + "'" );
        buf.append( "\n" ); 
        buf.append( "version = '" );
        buf.append( getVersion() + "'" );
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
