/*
 * $Id$
 */

package org.apache.maven.plugin.javadoc.options;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * A Taglet parameter.
 * 
 * @version $Revision$ $Date$
 */
public class Taglet implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field tagletClass
     */
    private String tagletClass;

    /**
     * Field tagletpath
     */
    private String tagletpath;

    /**
     * Field tagletArtifact
     */
    private TagletArtifact tagletArtifact;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals
     * 
     * @param other
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof Taglet) )
        {
            return false;
        }
        
        Taglet that = (Taglet) other;
        boolean result = true;
        result = result && ( getTagletClass() == null ? that.getTagletClass() == null : getTagletClass().equals( that.getTagletClass() ) );
        result = result && ( getTagletpath() == null ? that.getTagletpath() == null : getTagletpath().equals( that.getTagletpath() ) );
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get Specifies the taglet artifact to be included in the
     * tagletpath option for finding taglet class files (.class).
     */
    public TagletArtifact getTagletArtifact()
    {
        return this.tagletArtifact;
    } //-- TagletArtifact getTagletArtifact() 

    /**
     * Get tagletClass is the fully-qualified name for the taglet
     * class.
     */
    public String getTagletClass()
    {
        return this.tagletClass;
    } //-- String getTagletClass() 

    /**
     * Get Specifies the search paths for finding taglet class
     * files (.class).
     */
    public String getTagletpath()
    {
        return this.tagletpath;
    } //-- String getTagletpath() 

    /**
     * Method hashCode
     */
    public int hashCode()
    {
        int result = 17;
        long tmp;
        result = 37 * result + ( tagletClass != null ? tagletClass.hashCode() : 0 );
        result = 37 * result + ( tagletpath != null ? tagletpath.hashCode() : 0 );
        return result;
    } //-- int hashCode() 

    /**
     * Set Specifies the taglet artifact to be included in the
     * tagletpath option for finding taglet class files (.class).
     * 
     * @param tagletArtifact
     */
    public void setTagletArtifact(TagletArtifact tagletArtifact)
    {
        this.tagletArtifact = tagletArtifact;
    } //-- void setTagletArtifact(TagletArtifact) 

    /**
     * Set tagletClass is the fully-qualified name for the taglet
     * class.
     * 
     * @param tagletClass
     */
    public void setTagletClass(String tagletClass)
    {
        this.tagletClass = tagletClass;
    } //-- void setTagletClass(String) 

    /**
     * Set Specifies the search paths for finding taglet class
     * files (.class).
     * 
     * @param tagletpath
     */
    public void setTagletpath(String tagletpath)
    {
        this.tagletpath = tagletpath;
    } //-- void setTagletpath(String) 

    /**
     * Method toString
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        buf.append( "tagletClass = '" );
        buf.append( getTagletClass() + "'" );
        buf.append( "\n" ); 
        buf.append( "tagletpath = '" );
        buf.append( getTagletpath() + "'" );
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
