package org.apache.maven.plugin.pmd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-pmd-plugin.<br/> Call <pre>  mvn pmd:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Sun Feb 12 12:10:49 CET 2012
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.8)
 * @goal help
 * @requiresProject false
 * @threadSafe
 */
@SuppressWarnings( "all" )
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.apache.maven.plugins:maven-pmd-plugin:2.7.1", 0 );
        append( sb, "", 0 );

        append( sb, "Maven PMD Plugin", 0 );
        append( sb, "A Maven plugin for the PMD toolkit, that produces a report on both code rule violations and detected copy and paste fragments, as well as being able to fail the build based on these metrics.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 5 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "check".equals( goal ) )
        {
            append( sb, "pmd:check", 0 );
            append( sb, "Fail the build if there were any PMD violations in the source code.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "aggregate (Default: false)", 2 );
                append( sb, "Whether to build an aggregated report at the root, or build individual reports.", 3 );
                append( sb, "Expression: ${aggregate}", 3 );
                append( sb, "", 0 );

                append( sb, "failOnViolation (Default: true)", 2 );
                append( sb, "Whether to fail the build if the validation check fails.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${pmd.failOnViolation}", 3 );
                append( sb, "", 0 );

                append( sb, "failurePriority (Default: 5)", 2 );
                append( sb, "What priority level to fail the build on. Failures at or above this level will stop the build. Anything below will be warnings and will be displayed in the build output if verbose=true. Note: Minimum Priority = 5 Maximum Priority = 0", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${pmd.failurePriority}", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Skip the PMD checks. Most useful on the command line via \'-Dpmd.skip=true\'.", 3 );
                append( sb, "Expression: ${pmd.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "targetDirectory", 2 );
                append( sb, "The location of the XML report to check, as generated by the PMD report.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Print details of check failures to build output.", 3 );
                append( sb, "Expression: ${pmd.verbose}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "cpd".equals( goal ) )
        {
            append( sb, "pmd:cpd", 0 );
            append( sb, "Creates a report for PMD\'s CPD tool. See http://pmd.sourceforge.net/cpd.html for more detail.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "aggregate (Default: false)", 2 );
                append( sb, "Whether to build an aggregated report at the root, or build individual reports.", 3 );
                append( sb, "Expression: ${aggregate}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeRoots", 2 );
                append( sb, "The project source directories that should be excluded.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A list of files to exclude from checking. Can contain Ant-style wildcards and double wildcards. Note that these exclusion patterns only operate on the path of a source file relative to its source root directory. In other words, files are excluded based on their package and/or class name. If you want to exclude entire source root directories, use the parameter excludeRoots instead.", 3 );
                append( sb, "", 0 );

                append( sb, "format (Default: xml)", 2 );
                append( sb, "Set the output format type, in addition to the HTML report. Must be one of: \'none\', \'csv\', \'xml\', \'txt\' or the full class name of the PMD renderer to use. See the net.sourceforge.pmd.renderers package javadoc for available renderers. XML is required if the pmd:check goal is being used.", 3 );
                append( sb, "Expression: ${format}", 3 );
                append( sb, "", 0 );

                append( sb, "ignoreIdentifiers (Default: false)", 2 );
                append( sb, "Similar to ignoreLiterals but for identifiers; i.e., variable names, methods names, and so forth.", 3 );
                append( sb, "Expression: ${cpd.ignoreIdentifiers}", 3 );
                append( sb, "", 0 );

                append( sb, "ignoreLiterals (Default: false)", 2 );
                append( sb, "If true, CPD ignores literal value differences when evaluating a duplicate block. This means that foo=42; and foo=43; will be seen as equivalent. You may want to run PMD with this option off to start with and then switch it on to see what it turns up.", 3 );
                append( sb, "Expression: ${cpd.ignoreLiterals}", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A list of files to include from checking. Can contain Ant-style wildcards and double wildcards. Defaults to **\\/*.java.", 3 );
                append( sb, "", 0 );

                append( sb, "includeTests (Default: false)", 2 );
                append( sb, "Run PMD on the tests.", 3 );
                append( sb, "", 0 );

                append( sb, "linkXRef (Default: true)", 2 );
                append( sb, "Link the violation line numbers to the source xref. Links will be created automatically if the jxr plugin is being used.", 3 );
                append( sb, "Expression: ${linkXRef}", 3 );
                append( sb, "", 0 );

                append( sb, "minimumTokens (Default: 100)", 2 );
                append( sb, "The minimum number of tokens that need to be duplicated before it causes a violation.", 3 );
                append( sb, "Expression: ${minimumTokens}", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory for the final HTML report. Note that this parameter is only evaluated if the goal is run directly from the command line or during the default lifecycle. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${project.reporting.outputDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2 );
                append( sb, "The file encoding when writing non-HTML reports.", 3 );
                append( sb, "Expression: ${outputEncoding}", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Skip the CPD report generation. Most useful on the command line via \'-Dcpd.skip=true\'.", 3 );
                append( sb, "Expression: ${cpd.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "sourceEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The file encoding to use when reading the Java sources.", 3 );
                append( sb, "Expression: ${encoding}", 3 );
                append( sb, "", 0 );

                append( sb, "targetDirectory", 2 );
                append( sb, "The output directory for the intermediate XML report.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "xrefLocation (Default: ${project.reporting.outputDirectory}/xref)", 2 );
                append( sb, "Location of the Xrefs to link to.", 3 );
                append( sb, "", 0 );

                append( sb, "xrefTestLocation (Default: ${project.reporting.outputDirectory}/xref-test)", 2 );
                append( sb, "Location of the Test Xrefs to link to.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "cpd-check".equals( goal ) )
        {
            append( sb, "pmd:cpd-check", 0 );
            append( sb, "Fail the build if there were any CPD violations in the source code.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "aggregate (Default: false)", 2 );
                append( sb, "Whether to build an aggregated report at the root, or build individual reports.", 3 );
                append( sb, "Expression: ${aggregate}", 3 );
                append( sb, "", 0 );

                append( sb, "failOnViolation (Default: true)", 2 );
                append( sb, "Whether to fail the build if the validation check fails.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${pmd.failOnViolation}", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Skip the CPD violation checks. Most useful on the command line via \'-Dcpd.skip=true\'.", 3 );
                append( sb, "Expression: ${cpd.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "targetDirectory", 2 );
                append( sb, "The location of the XML report to check, as generated by the PMD report.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Print details of check failures to build output.", 3 );
                append( sb, "Expression: ${pmd.verbose}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "pmd:help", 0 );
            append( sb, "Display help information on maven-pmd-plugin.\nCall\n\u00a0\u00a0mvn\u00a0pmd:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "Expression: ${detail}", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "Expression: ${goal}", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "Expression: ${indentSize}", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "Expression: ${lineLength}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "pmd".equals( goal ) )
        {
            append( sb, "pmd:pmd", 0 );
            append( sb, "Creates a PMD report.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "aggregate (Default: false)", 2 );
                append( sb, "Whether to build an aggregated report at the root, or build individual reports.", 3 );
                append( sb, "Expression: ${aggregate}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeRoots", 2 );
                append( sb, "The project source directories that should be excluded.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A list of files to exclude from checking. Can contain Ant-style wildcards and double wildcards. Note that these exclusion patterns only operate on the path of a source file relative to its source root directory. In other words, files are excluded based on their package and/or class name. If you want to exclude entire source root directories, use the parameter excludeRoots instead.", 3 );
                append( sb, "", 0 );

                append( sb, "format (Default: xml)", 2 );
                append( sb, "Set the output format type, in addition to the HTML report. Must be one of: \'none\', \'csv\', \'xml\', \'txt\' or the full class name of the PMD renderer to use. See the net.sourceforge.pmd.renderers package javadoc for available renderers. XML is required if the pmd:check goal is being used.", 3 );
                append( sb, "Expression: ${format}", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A list of files to include from checking. Can contain Ant-style wildcards and double wildcards. Defaults to **\\/*.java.", 3 );
                append( sb, "", 0 );

                append( sb, "includeTests (Default: false)", 2 );
                append( sb, "Run PMD on the tests.", 3 );
                append( sb, "", 0 );

                append( sb, "linkXRef (Default: true)", 2 );
                append( sb, "Link the violation line numbers to the source xref. Links will be created automatically if the jxr plugin is being used.", 3 );
                append( sb, "Expression: ${linkXRef}", 3 );
                append( sb, "", 0 );

                append( sb, "minimumPriority (Default: 5)", 2 );
                append( sb, "The rule priority threshold; rules with lower priority than this will not be evaluated.", 3 );
                append( sb, "Expression: ${minimumPriority}", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The output directory for the final HTML report. Note that this parameter is only evaluated if the goal is run directly from the command line or during the default lifecycle. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${project.reporting.outputDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2 );
                append( sb, "The file encoding when writing non-HTML reports.", 3 );
                append( sb, "Expression: ${outputEncoding}", 3 );
                append( sb, "", 0 );

                append( sb, "rulesets", 2 );
                append( sb, "The PMD rulesets to use. See the Stock Rulesets for a list of some included. Since version 2.5, the ruleset \'rulesets/maven.xml\' is also available. Defaults to the basic, imports and unusedcode rulesets.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Skip the PMD report generation. Most useful on the command line via \'-Dpmd.skip=true\'.", 3 );
                append( sb, "Expression: ${pmd.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "sourceEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The file encoding to use when reading the Java sources.", 3 );
                append( sb, "Expression: ${encoding}", 3 );
                append( sb, "", 0 );

                append( sb, "targetDirectory", 2 );
                append( sb, "The output directory for the intermediate XML report.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "targetJdk", 2 );
                append( sb, "The target JDK to analyze based on. Should match the target used in the compiler plugin. Valid values are currently 1.3, 1.4, 1.5 and 1.6.\nNote: support for 1.6 was added in version 2.3 of this plugin.\n", 3 );
                append( sb, "Expression: ${targetJdk}", 3 );
                append( sb, "", 0 );

                append( sb, "xrefLocation (Default: ${project.reporting.outputDirectory}/xref)", 2 );
                append( sb, "Location of the Xrefs to link to.", 3 );
                append( sb, "", 0 );

                append( sb, "xrefTestLocation (Default: ${project.reporting.outputDirectory}/xref-test)", 2 );
                append( sb, "Location of the Test Xrefs to link to.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List<String> lines = new ArrayList<String>();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List<String> lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
