/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.maven.plugin.testing.AbstractMojoTestCase;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractPropertyUtilsTest
extends AbstractMojoTestCase {
    protected File propertyFile;
    protected File validationFile;
    protected Properties validationProp;

    protected abstract File getPropertyFile();

    protected abstract File getValidationFile();

    protected void setUp() throws Exception {
        super.setUp();
        this.propertyFile = this.getPropertyFile();
        AbstractPropertyUtilsTest.assertNotNull((Object)this.propertyFile);
        this.validationFile = this.getValidationFile();
        AbstractPropertyUtilsTest.assertNotNull((Object)this.validationFile);
        this.loadValidationProperties(this.validationFile);
    }

    protected boolean validateProperties(Properties prop) {
        String key;
        boolean bRetVal = false;
        Enumeration<Object> propKeys = prop.keys();
        while (propKeys.hasMoreElements() && (bRetVal = prop.getProperty(key = (String)propKeys.nextElement()).equals(this.validationProp.getProperty(key)))) {
        }
        return bRetVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadValidationProperties(File validationPropFile) {
        this.validationProp = new Properties();
        InputStream in = null;
        try {
            in = Files.newInputStream(validationPropFile.toPath(), new OpenOption[0]);
            this.validationProp.load(in);
            in.close();
            in = null;
        }
        catch (IOException iOException) {
            IOUtil.close(in);
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            throw throwable;
        }
        IOUtil.close((InputStream)in);
    }
}

