/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.resources;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.testing.AbstractMojoTestCase;
import org.apache.maven.plugins.resources.ResourcesMojo;
import org.apache.maven.plugins.resources.stub.MavenProjectResourcesStub;
import org.codehaus.plexus.util.FileUtils;

public class ResourcesMojoTest
extends AbstractMojoTestCase {
    protected static final String defaultPomFilePath = "/target/test-classes/unit/resources-test/plugin-config.xml";

    public void testHarnessEnvironment() throws Exception {
        File testPom = new File(ResourcesMojoTest.getBasedir(), defaultPomFilePath);
        ResourcesMojo mojo = (ResourcesMojo)this.lookupMojo("resources", testPom);
        ResourcesMojoTest.assertNotNull((Object)mojo);
    }

    public void testResourceDirectoryStructure() throws Exception {
        File testPom = new File(ResourcesMojoTest.getBasedir(), defaultPomFilePath);
        ResourcesMojo mojo = (ResourcesMojo)this.lookupMojo("resources", testPom);
        MavenProjectResourcesStub project = new MavenProjectResourcesStub("resourceDirectoryStructure");
        List resources = project.getBuild().getResources();
        ResourcesMojoTest.assertNotNull((Object)mojo);
        project.addFile("file4.txt");
        project.addFile("package/file3.nottest");
        project.addFile("notpackage/file1.include");
        project.addFile("package/test/file1.txt");
        project.addFile("notpackage/test/file2.txt");
        project.setupBuildEnvironment();
        this.setVariableValueToObject(mojo, "project", (Object)project);
        this.setVariableValueToObject(mojo, "resources", resources);
        this.setVariableValueToObject(mojo, "outputDirectory", new File(project.getBuild().getOutputDirectory()));
        this.setVariableValueToObject(mojo, "buildFilters", Collections.emptyList());
        this.setVariableValueToObject(mojo, "useBuildFilters", Boolean.TRUE);
        mojo.execute();
        String resourcesDir = project.getOutputDirectory();
        ResourcesMojoTest.assertTrue((boolean)FileUtils.fileExists((String)(resourcesDir + "/file4.txt")));
        ResourcesMojoTest.assertTrue((boolean)FileUtils.fileExists((String)(resourcesDir + "/package/file3.nottest")));
        ResourcesMojoTest.assertTrue((boolean)FileUtils.fileExists((String)(resourcesDir + "/notpackage/file1.include")));
        ResourcesMojoTest.assertTrue((boolean)FileUtils.fileExists((String)(resourcesDir + "/package/test")));
        ResourcesMojoTest.assertTrue((boolean)FileUtils.fileExists((String)(resourcesDir + "/notpackage/test")));
    }

    public void testResourceDirectoryStructure_RelativePath() throws Exception {
        File testPom = new File(ResourcesMojoTest.getBasedir(), defaultPomFilePath);
        ResourcesMojo mojo = (ResourcesMojo)this.lookupMojo("resources", testPom);
        MavenProjectResourcesStub project = new MavenProjectResourcesStub("resourceDirectoryStructure_RelativePath");
        List resources = project.getBuild().getResources();
        ResourcesMojoTest.assertNotNull((Object)mojo);
        project.setOutputDirectory("../relative_dir");
        project.addFile("file4.txt");
        project.addFile("package/file3.nottest");
        project.addFile("notpackage/file1.include");
        project.addFile("package/test/file1.txt");
        project.addFile("notpackage/test/file2.txt");
        project.setupBuildEnvironment();
        this.setVariableValueToObject(mojo, "outputDirectory", new File(project.getBuild().getOutputDirectory()));
        this.setVariableValueToObject(mojo, "project", (Object)project);
        this.setVariableValueToObject(mojo, "resources", resources);
        this.setVariableValueToObject(mojo, "buildFilters", Collections.emptyList());
        this.setVariableValueToObject(mojo, "useBuildFilters", Boolean.TRUE);
        mojo.execute();
        String resourcesDir = project.getOutputDirectory();
        ResourcesMojoTest.assertTrue((boolean)FileUtils.fileExists((String)(resourcesDir + "/file4.txt")));
        ResourcesMojoTest.assertTrue((boolean)FileUtils.fileExists((String)(resourcesDir + "/package/file3.nottest")));
        ResourcesMojoTest.assertTrue((boolean)FileUtils.fileExists((String)(resourcesDir + "/notpackage/file1.include")));
        ResourcesMojoTest.assertTrue((boolean)FileUtils.fileExists((String)(resourcesDir + "/package/test")));
        ResourcesMojoTest.assertTrue((boolean)FileUtils.fileExists((String)(resourcesDir + "/notpackage/test")));
    }

    public void testResourceEncoding() throws Exception {
        File testPom = new File(ResourcesMojoTest.getBasedir(), defaultPomFilePath);
        ResourcesMojo mojo = (ResourcesMojo)this.lookupMojo("resources", testPom);
        MavenProjectResourcesStub project = new MavenProjectResourcesStub("encoding");
        List resources = project.getBuild().getResources();
        ResourcesMojoTest.assertNotNull((Object)mojo);
        project.addFile("file4.txt");
        project.setResourceFiltering(0, true);
        project.setupBuildEnvironment();
        this.setVariableValueToObject(mojo, "encoding", "UTF-8");
        this.setVariableValueToObject(mojo, "project", (Object)project);
        this.setVariableValueToObject(mojo, "resources", resources);
        this.setVariableValueToObject(mojo, "outputDirectory", new File(project.getBuild().getOutputDirectory()));
        this.setVariableValueToObject(mojo, "buildFilters", Collections.emptyList());
        this.setVariableValueToObject(mojo, "useBuildFilters", Boolean.TRUE);
        mojo.execute();
        String resourcesDir = project.getOutputDirectory();
        ResourcesMojoTest.assertTrue((boolean)FileUtils.fileExists((String)(resourcesDir + "/file4.txt")));
    }

    public void testResourceInclude() throws Exception {
        File testPom = new File(ResourcesMojoTest.getBasedir(), defaultPomFilePath);
        ResourcesMojo mojo = (ResourcesMojo)this.lookupMojo("resources", testPom);
        MavenProjectResourcesStub project = new MavenProjectResourcesStub("resourceInclude");
        List resources = project.getBuild().getResources();
        ResourcesMojoTest.assertNotNull((Object)mojo);
        project.addFile("file1.include");
        project.addFile("file2.exclude");
        project.addFile("file3.nottest");
        project.addFile("file4.txt");
        project.addFile("package/file1.include");
        project.addFile("package/file2.exclude");
        project.addFile("package/file3.nottest");
        project.addFile("package/file4.txt");
        project.addFile("notpackage/file1.include");
        project.addFile("notpackage/file2.exclude");
        project.addFile("notpackage/file3.nottest");
        project.addFile("notpackage/file4.txt");
        project.addFile("package/test/file1.txt");
        project.addFile("package/nottest/file2.txt");
        project.addFile("notpackage/test/file1.txt");
        project.addFile("notpackage/nottest/file.txt");
        project.setupBuildEnvironment();
        project.addInclude("*.include");
        project.addInclude("**/test");
        project.addInclude("**/test/file*");
        project.addInclude("**/package/*.include");
        this.setVariableValueToObject(mojo, "outputDirectory", new File(project.getBuild().getOutputDirectory()));
        this.setVariableValueToObject(mojo, "project", (Object)project);
        this.setVariableValueToObject(mojo, "resources", resources);
        this.setVariableValueToObject(mojo, "buildFilters", Collections.emptyList());
        this.setVariableValueToObject(mojo, "useBuildFilters", Boolean.TRUE);
        mojo.execute();
        String resourcesDir = project.getOutputDirectory();
        ResourcesMojoTest.assertTrue((boolean)FileUtils.fileExists((String)(resourcesDir + "/package/test")));
        ResourcesMojoTest.assertTrue((boolean)FileUtils.fileExists((String)(resourcesDir + "/file1.include")));
        ResourcesMojoTest.assertTrue((boolean)FileUtils.fileExists((String)(resourcesDir + "/package/file1.include")));
        ResourcesMojoTest.assertFalse((boolean)FileUtils.fileExists((String)(resourcesDir + "/notpackage/file1.include")));
        ResourcesMojoTest.assertFalse((boolean)FileUtils.fileExists((String)(resourcesDir + "/notpackage/nottest/file.txt")));
    }

    public void testResourceExclude() throws Exception {
        File testPom = new File(ResourcesMojoTest.getBasedir(), defaultPomFilePath);
        ResourcesMojo mojo = (ResourcesMojo)this.lookupMojo("resources", testPom);
        MavenProjectResourcesStub project = new MavenProjectResourcesStub("resourceExclude");
        List resources = project.getBuild().getResources();
        ResourcesMojoTest.assertNotNull((Object)mojo);
        project.addFile("file1.include");
        project.addFile("file2.exclude");
        project.addFile("file3.nottest");
        project.addFile("file4.txt");
        project.addFile("package/file1.include");
        project.addFile("package/file2.exclude");
        project.addFile("package/file3.nottest");
        project.addFile("package/file4.txt");
        project.addFile("notpackage/file1.include");
        project.addFile("notpackage/file2.exclude");
        project.addFile("notpackage/file3.nottest");
        project.addFile("notpackage/file4.txt");
        project.addFile("package/test/file1.txt");
        project.addFile("package/nottest/file2.txt");
        project.addFile("notpackage/test/file1.txt");
        project.addFile("notpackage/nottest/file.txt");
        project.setupBuildEnvironment();
        project.addExclude("**/*.exclude");
        project.addExclude("**/nottest*");
        project.addExclude("**/notest");
        project.addExclude("**/notpackage*");
        project.addExclude("**/notpackage*/**");
        this.setVariableValueToObject(mojo, "outputDirectory", new File(project.getBuild().getOutputDirectory()));
        this.setVariableValueToObject(mojo, "project", (Object)project);
        this.setVariableValueToObject(mojo, "resources", resources);
        this.setVariableValueToObject(mojo, "buildFilters", Collections.emptyList());
        this.setVariableValueToObject(mojo, "useBuildFilters", Boolean.TRUE);
        mojo.execute();
        String resourcesDir = project.getOutputDirectory();
        ResourcesMojoTest.assertTrue((boolean)FileUtils.fileExists((String)(resourcesDir + "/package/test")));
        ResourcesMojoTest.assertTrue((boolean)FileUtils.fileExists((String)(resourcesDir + "/file1.include")));
        ResourcesMojoTest.assertTrue((boolean)FileUtils.fileExists((String)(resourcesDir + "/package/file1.include")));
        ResourcesMojoTest.assertFalse((boolean)FileUtils.fileExists((String)(resourcesDir + "/notpackage/file1.include")));
        ResourcesMojoTest.assertFalse((boolean)FileUtils.fileExists((String)(resourcesDir + "/notpackage/nottest/file.txt")));
    }

    public void testResourceTargetPath() throws Exception {
        File testPom = new File(ResourcesMojoTest.getBasedir(), defaultPomFilePath);
        ResourcesMojo mojo = (ResourcesMojo)this.lookupMojo("resources", testPom);
        MavenProjectResourcesStub project = new MavenProjectResourcesStub("resourceTargetPath");
        List resources = project.getBuild().getResources();
        ResourcesMojoTest.assertNotNull((Object)mojo);
        project.setTargetPath("org/apache/maven/plugin/test");
        project.addFile("file4.txt");
        project.addFile("package/file3.nottest");
        project.addFile("notpackage/file1.include");
        project.addFile("package/test/file1.txt");
        project.addFile("notpackage/test/file2.txt");
        project.setupBuildEnvironment();
        this.setVariableValueToObject(mojo, "outputDirectory", new File(project.getBuild().getOutputDirectory()));
        this.setVariableValueToObject(mojo, "project", (Object)project);
        this.setVariableValueToObject(mojo, "resources", resources);
        this.setVariableValueToObject(mojo, "buildFilters", Collections.emptyList());
        this.setVariableValueToObject(mojo, "useBuildFilters", Boolean.TRUE);
        mojo.execute();
        String resourcesDir = project.getOutputDirectory();
        ResourcesMojoTest.assertTrue((boolean)FileUtils.fileExists((String)(resourcesDir + "/org/apache/maven/plugin/test/file4.txt")));
        ResourcesMojoTest.assertTrue((boolean)FileUtils.fileExists((String)(resourcesDir + "/org/apache/maven/plugin/test/package/file3.nottest")));
        ResourcesMojoTest.assertTrue((boolean)FileUtils.fileExists((String)(resourcesDir + "/org/apache/maven/plugin/test/notpackage/file1.include")));
        ResourcesMojoTest.assertTrue((boolean)FileUtils.fileExists((String)(resourcesDir + "/org/apache/maven/plugin/test/package/test")));
        ResourcesMojoTest.assertTrue((boolean)FileUtils.fileExists((String)(resourcesDir + "/org/apache/maven/plugin/test/notpackage/test")));
    }

    public void testResourceSystemProperties_Filtering() throws Exception {
        File testPom = new File(ResourcesMojoTest.getBasedir(), defaultPomFilePath);
        ResourcesMojo mojo = (ResourcesMojo)this.lookupMojo("resources", testPom);
        MavenProjectResourcesStub project = new MavenProjectResourcesStub("resourceSystemProperties_Filtering");
        List resources = project.getBuild().getResources();
        ResourcesMojoTest.assertNotNull((Object)mojo);
        project.addFile("file4.txt", "current-working-directory = ${user.dir}");
        project.setResourceFiltering(0, true);
        project.setupBuildEnvironment();
        this.setVariableValueToObject(mojo, "project", (Object)project);
        this.setVariableValueToObject(mojo, "resources", resources);
        this.setVariableValueToObject(mojo, "outputDirectory", new File(project.getBuild().getOutputDirectory()));
        this.setVariableValueToObject(mojo, "buildFilters", Collections.emptyList());
        this.setVariableValueToObject(mojo, "useBuildFilters", Boolean.TRUE);
        this.setVariableValueToObject(mojo, "escapeWindowsPaths", Boolean.TRUE);
        DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest();
        request.setSystemProperties(System.getProperties());
        MavenSession mavenSession = new MavenSession(null, null, (MavenExecutionRequest)request, null);
        this.setVariableValueToObject(mojo, "session", mavenSession);
        mojo.execute();
        String resourcesDir = project.getOutputDirectory();
        File userDir = new File(System.getProperty("user.dir"));
        ResourcesMojoTest.assertTrue((boolean)userDir.exists());
        Properties props = new Properties();
        try (FileInputStream inStream = new FileInputStream(new File(resourcesDir, "file4.txt"));){
            props.load(inStream);
        }
        File fileFromFiltering = new File(props.getProperty("current-working-directory"));
        ResourcesMojoTest.assertTrue((String)(fileFromFiltering.getAbsolutePath() + " does not exist."), (boolean)fileFromFiltering.exists());
        ResourcesMojoTest.assertEquals((String)userDir.getAbsolutePath(), (String)fileFromFiltering.getAbsolutePath());
    }

    public void testResourceProjectProperties_Filtering() throws Exception {
        File testPom = new File(ResourcesMojoTest.getBasedir(), defaultPomFilePath);
        ResourcesMojo mojo = (ResourcesMojo)this.lookupMojo("resources", testPom);
        MavenProjectResourcesStub project = new MavenProjectResourcesStub("resourceProjectProperties_Filtering");
        List resources = project.getBuild().getResources();
        ResourcesMojoTest.assertNotNull((Object)mojo);
        project.addFile("file4.txt", "current working directory = ${user.dir}");
        project.setResourceFiltering(0, true);
        project.addProperty("user.dir", "FPJ kami!!!");
        project.setupBuildEnvironment();
        this.setVariableValueToObject(mojo, "project", (Object)project);
        this.setVariableValueToObject(mojo, "resources", resources);
        this.setVariableValueToObject(mojo, "outputDirectory", new File(project.getBuild().getOutputDirectory()));
        this.setVariableValueToObject(mojo, "buildFilters", Collections.emptyList());
        this.setVariableValueToObject(mojo, "useBuildFilters", Boolean.TRUE);
        mojo.execute();
        String resourcesDir = project.getOutputDirectory();
        String checkString = "current working directory = FPJ kami!!!";
        this.assertContent(resourcesDir + "/file4.txt", checkString);
    }

    public void testProjectProperty_Filtering_PropertyDestination() throws Exception {
        File testPom = new File(ResourcesMojoTest.getBasedir(), defaultPomFilePath);
        ResourcesMojo mojo = (ResourcesMojo)this.lookupMojo("resources", testPom);
        MavenProjectResourcesStub project = new MavenProjectResourcesStub("resourcePojectProperty_Filtering_PropertyDestination");
        List resources = project.getBuild().getResources();
        ResourcesMojoTest.assertNotNull((Object)mojo);
        project.addFile("file4.properties", "current working directory=${description}");
        project.setResourceFiltering(0, true);
        project.setupBuildEnvironment();
        project.setDescription("c:\\\\org\\apache\\test");
        this.setVariableValueToObject(mojo, "project", (Object)project);
        this.setVariableValueToObject(mojo, "resources", resources);
        this.setVariableValueToObject(mojo, "outputDirectory", new File(project.getBuild().getOutputDirectory()));
        this.setVariableValueToObject(mojo, "buildFilters", Collections.emptyList());
        this.setVariableValueToObject(mojo, "useBuildFilters", Boolean.TRUE);
        this.setVariableValueToObject(mojo, "escapeWindowsPaths", Boolean.TRUE);
        mojo.execute();
        String resourcesDir = project.getOutputDirectory();
        String checkString = "current working directory=c:\\\\org\\\\apache\\\\test";
        this.assertContent(resourcesDir + "/file4.properties", checkString);
    }

    public void testPropertyFiles_Filtering() throws Exception {
        File testPom = new File(ResourcesMojoTest.getBasedir(), defaultPomFilePath);
        ResourcesMojo mojo = (ResourcesMojo)this.lookupMojo("resources", testPom);
        MavenProjectResourcesStub project = new MavenProjectResourcesStub("resourcePropertyFiles_Filtering");
        List resources = project.getBuild().getResources();
        LinkedList<String> filterList = new LinkedList<String>();
        ResourcesMojoTest.assertNotNull((Object)mojo);
        project.addFile("file4.properties", "current working directory=${dir}");
        project.addFile("filter.properties", "dir:testdir");
        project.setResourceFiltering(0, true);
        project.setupBuildEnvironment();
        filterList.add(project.getResourcesDirectory() + "filter.properties");
        this.setVariableValueToObject(mojo, "project", (Object)project);
        this.setVariableValueToObject(mojo, "resources", resources);
        this.setVariableValueToObject(mojo, "outputDirectory", new File(project.getBuild().getOutputDirectory()));
        this.setVariableValueToObject(mojo, "buildFilters", filterList);
        this.setVariableValueToObject(mojo, "useBuildFilters", Boolean.TRUE);
        mojo.execute();
        String resourcesDir = project.getOutputDirectory();
        String checkString = "current working directory=testdir";
        this.assertContent(resourcesDir + "/file4.properties", checkString);
    }

    public void testPropertyFiles_Extra() throws Exception {
        File testPom = new File(ResourcesMojoTest.getBasedir(), defaultPomFilePath);
        ResourcesMojo mojo = (ResourcesMojo)this.lookupMojo("resources", testPom);
        MavenProjectResourcesStub project = new MavenProjectResourcesStub("resourcePropertyFiles_Extra");
        List resources = project.getBuild().getResources();
        LinkedList<String> filterList = new LinkedList<String>();
        ResourcesMojoTest.assertNotNull((Object)mojo);
        project.addFile("extra.properties", "current working directory=${dir}");
        project.addFile("filter.properties", "dir:testdir");
        project.setResourceFiltering(0, true);
        project.setupBuildEnvironment();
        filterList.add(project.getResourcesDirectory() + "filter.properties");
        this.setVariableValueToObject(mojo, "project", (Object)project);
        this.setVariableValueToObject(mojo, "resources", resources);
        this.setVariableValueToObject(mojo, "outputDirectory", new File(project.getBuild().getOutputDirectory()));
        this.setVariableValueToObject(mojo, "filters", filterList);
        this.setVariableValueToObject(mojo, "useBuildFilters", Boolean.TRUE);
        mojo.execute();
        String resourcesDir = project.getOutputDirectory();
        String checkString = "current working directory=testdir";
        this.assertContent(resourcesDir + "/extra.properties", checkString);
    }

    public void testPropertyFiles_MainAndExtra() throws Exception {
        File testPom = new File(ResourcesMojoTest.getBasedir(), defaultPomFilePath);
        ResourcesMojo mojo = (ResourcesMojo)this.lookupMojo("resources", testPom);
        MavenProjectResourcesStub project = new MavenProjectResourcesStub("resourcePropertyFiles_MainAndExtra");
        List resources = project.getBuild().getResources();
        LinkedList<String> filterList = new LinkedList<String>();
        LinkedList<String> extraFilterList = new LinkedList<String>();
        ResourcesMojoTest.assertNotNull((Object)mojo);
        project.addFile("main-extra.properties", "current working directory=${dir}; old working directory=${dir2}");
        project.addFile("filter.properties", "dir:testdir");
        project.addFile("extra-filter.properties", "dir2:testdir2");
        project.setResourceFiltering(0, true);
        project.cleanBuildEnvironment();
        project.setupBuildEnvironment();
        filterList.add(project.getResourcesDirectory() + "filter.properties");
        extraFilterList.add(project.getResourcesDirectory() + "extra-filter.properties");
        this.setVariableValueToObject(mojo, "project", (Object)project);
        this.setVariableValueToObject(mojo, "resources", resources);
        this.setVariableValueToObject(mojo, "outputDirectory", new File(project.getBuild().getOutputDirectory()));
        this.setVariableValueToObject(mojo, "buildFilters", filterList);
        this.setVariableValueToObject(mojo, "filters", extraFilterList);
        this.setVariableValueToObject(mojo, "useBuildFilters", Boolean.TRUE);
        mojo.execute();
        String resourcesDir = project.getOutputDirectory();
        String checkString = "current working directory=testdir; old working directory=testdir2";
        File file = new File(resourcesDir, "main-extra.properties");
        this.assertContent(file.getAbsolutePath(), checkString);
    }

    public void testPropertyFiles_Filtering_TokensInFilters() throws Exception {
        File testPom = new File(ResourcesMojoTest.getBasedir(), defaultPomFilePath);
        ResourcesMojo mojo = (ResourcesMojo)this.lookupMojo("resources", testPom);
        MavenProjectResourcesStub project = new MavenProjectResourcesStub("resourcePropertyFiles_Filtering_TokensInFilters");
        List resources = project.getBuild().getResources();
        LinkedList<String> filterList = new LinkedList<String>();
        ResourcesMojoTest.assertNotNull((Object)mojo);
        project.addFile("file4.properties", "current working directory=${filter.token}");
        project.addFile("filter.properties", "filter.token=${pom-property}");
        project.setResourceFiltering(0, true);
        project.addProperty("pom-property", "foobar");
        project.setupBuildEnvironment();
        filterList.add(project.getResourcesDirectory() + "filter.properties");
        this.setVariableValueToObject(mojo, "project", (Object)project);
        this.setVariableValueToObject(mojo, "resources", resources);
        this.setVariableValueToObject(mojo, "outputDirectory", new File(project.getBuild().getOutputDirectory()));
        this.setVariableValueToObject(mojo, "buildFilters", filterList);
        this.setVariableValueToObject(mojo, "useBuildFilters", Boolean.TRUE);
        mojo.execute();
        String resourcesDir = project.getOutputDirectory();
        String checkString = "current working directory=foobar";
        this.assertContent(resourcesDir + "/file4.properties", "current working directory=foobar");
    }

    public void testWindowsPathEscapingDisabled() throws Exception {
        File testPom = new File(ResourcesMojoTest.getBasedir(), defaultPomFilePath);
        ResourcesMojo mojo = (ResourcesMojo)this.lookupMojo("resources", testPom);
        MavenProjectResourcesStub project = new MavenProjectResourcesStub("windows-paths");
        List resources = project.getBuild().getResources();
        ResourcesMojoTest.assertNotNull((Object)mojo);
        project.getProperties().setProperty("basePath", "C:\\Users\\Administrator");
        project.getProperties().setProperty("docsPath", "${basePath}\\Documents");
        project.addFile("path-listing.txt", "base path is ${basePath}\ndocuments path is ${docsPath}");
        project.setResourceFiltering(0, true);
        project.cleanBuildEnvironment();
        project.setupBuildEnvironment();
        this.setVariableValueToObject(mojo, "project", (Object)project);
        this.setVariableValueToObject(mojo, "resources", resources);
        this.setVariableValueToObject(mojo, "outputDirectory", new File(project.getBuild().getOutputDirectory()));
        this.setVariableValueToObject(mojo, "buildFilters", Collections.emptyList());
        this.setVariableValueToObject(mojo, "useBuildFilters", Boolean.TRUE);
        this.setVariableValueToObject(mojo, "escapeWindowsPaths", Boolean.FALSE);
        mojo.execute();
        String resourcesDir = project.getOutputDirectory();
        ResourcesMojoTest.assertTrue((boolean)FileUtils.fileExists((String)new File(resourcesDir, "path-listing.txt").getAbsolutePath()));
        ResourcesMojoTest.assertEquals((String)"base path is C:\\Users\\Administrator\ndocuments path is C:\\Users\\Administrator\\Documents", (String)FileUtils.fileRead((File)new File(resourcesDir, "path-listing.txt")));
    }

    public void testWindowsPathEscapingEnabled() throws Exception {
        File testPom = new File(ResourcesMojoTest.getBasedir(), defaultPomFilePath);
        ResourcesMojo mojo = (ResourcesMojo)this.lookupMojo("resources", testPom);
        MavenProjectResourcesStub project = new MavenProjectResourcesStub("windows-paths");
        List resources = project.getBuild().getResources();
        ResourcesMojoTest.assertNotNull((Object)mojo);
        project.getProperties().setProperty("basePath", "C:\\Users\\Administrator");
        project.getProperties().setProperty("docsPath", "${basePath}\\Documents");
        project.addFile("path-listing.txt", "base path is ${basePath}\ndocuments path is ${docsPath}");
        project.setResourceFiltering(0, true);
        project.cleanBuildEnvironment();
        project.setupBuildEnvironment();
        this.setVariableValueToObject(mojo, "project", (Object)project);
        this.setVariableValueToObject(mojo, "resources", resources);
        this.setVariableValueToObject(mojo, "outputDirectory", new File(project.getBuild().getOutputDirectory()));
        this.setVariableValueToObject(mojo, "buildFilters", Collections.emptyList());
        this.setVariableValueToObject(mojo, "useBuildFilters", Boolean.TRUE);
        this.setVariableValueToObject(mojo, "escapeWindowsPaths", Boolean.TRUE);
        mojo.execute();
        String resourcesDir = project.getOutputDirectory();
        ResourcesMojoTest.assertTrue((boolean)FileUtils.fileExists((String)new File(resourcesDir, "path-listing.txt").getAbsolutePath()));
        ResourcesMojoTest.assertEquals((String)"base path is C:\\\\Users\\\\Administrator\ndocuments path is C:\\\\Users\\\\Administrator\\\\Documents", (String)FileUtils.fileRead((File)new File(resourcesDir, "path-listing.txt")));
    }

    private void assertContent(String fileName, String data) throws IOException {
        ResourcesMojoTest.assertTrue((boolean)FileUtils.fileExists((String)fileName));
        try (BufferedReader reader = new BufferedReader(new FileReader(fileName));){
            ResourcesMojoTest.assertEquals((String)data, (String)reader.readLine());
        }
    }
}

