/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.resources;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.testing.AbstractMojoTestCase;
import org.apache.maven.plugins.resources.ResourcesMojo;
import org.apache.maven.plugins.resources.TestResourcesMojo;
import org.apache.maven.plugins.resources.stub.MavenProjectResourcesStub;
import org.codehaus.plexus.util.FileUtils;

public class TestResourcesTest
extends AbstractMojoTestCase {
    protected static final String defaultPomFilePath = "/target/test-classes/unit/resources-test/plugin-config.xml";

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testHarnessEnvironment() throws Exception {
        File testPom = new File(TestResourcesTest.getBasedir(), defaultPomFilePath);
        ResourcesMojo mojo = (ResourcesMojo)this.lookupMojo("testResources", testPom);
        TestResourcesTest.assertNotNull((Object)mojo);
    }

    public void testTestResourceDirectoryCreation() throws Exception {
        File testPom = new File(TestResourcesTest.getBasedir(), defaultPomFilePath);
        TestResourcesMojo mojo = (TestResourcesMojo)this.lookupMojo("testResources", testPom);
        MavenProjectResourcesStub project = new MavenProjectResourcesStub("testResourceDirectoryStructure");
        List resources = project.getBuild().getResources();
        TestResourcesTest.assertNotNull((Object)mojo);
        project.addFile("file4.txt");
        project.addFile("package/file3.nottest");
        project.addFile("notpackage/file1.include");
        project.addFile("package/test/file1.txt");
        project.addFile("notpackage/test/file2.txt");
        project.setupBuildEnvironment();
        this.setVariableValueToObject(mojo, "project", (Object)project);
        this.setVariableValueToObject(mojo, "resources", resources);
        this.setVariableValueToObject(mojo, "outputDirectory", new File(project.getBuild().getTestOutputDirectory()));
        this.setVariableValueToObject(mojo, "buildFilters", Collections.emptyList());
        this.setVariableValueToObject(mojo, "useBuildFilters", Boolean.TRUE);
        mojo.execute();
        String resorucesDir = project.getTestOutputDirectory();
        TestResourcesTest.assertTrue((boolean)FileUtils.fileExists((String)(resorucesDir + "/file4.txt")));
        TestResourcesTest.assertTrue((boolean)FileUtils.fileExists((String)(resorucesDir + "/package/file3.nottest")));
        TestResourcesTest.assertTrue((boolean)FileUtils.fileExists((String)(resorucesDir + "/notpackage/file1.include")));
        TestResourcesTest.assertTrue((boolean)FileUtils.fileExists((String)(resorucesDir + "/package/test")));
        TestResourcesTest.assertTrue((boolean)FileUtils.fileExists((String)(resorucesDir + "/notpackage/test")));
    }
}

