/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.resources.stub;

import java.io.File;
import java.util.Properties;
import org.apache.maven.plugin.testing.stubs.MavenProjectStub;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.util.FileUtils;

public class MavenProjectBasicStub
extends MavenProjectStub {
    protected String identifier;
    protected String testRootDir;
    protected Properties properties = new Properties();
    protected String description;

    public MavenProjectBasicStub(String id) {
        this.identifier = id;
        this.testRootDir = PlexusTestCase.getBasedir() + "/target/test-classes/unit/test-dir/" + this.identifier;
        if (!FileUtils.fileExists((String)this.testRootDir)) {
            FileUtils.mkdir((String)this.testRootDir);
        }
    }

    public String getName() {
        return "Test Project " + this.identifier;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getDescription() {
        if (this.description == null) {
            return "this is a test project";
        }
        return this.description;
    }

    public File getBasedir() {
        return new File(this.testRootDir);
    }

    public String getGroupId() {
        return "org.apache.maven.plugin.test";
    }

    public String getArtifactId() {
        return "maven-resource-plugin-test#" + this.identifier;
    }

    public String getPackaging() {
        return "org.apache.maven.plugin.test";
    }

    public String getVersion() {
        return this.identifier;
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public Properties getProperties() {
        return this.properties;
    }
}

