/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.resources.stub;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.maven.model.Build;
import org.apache.maven.plugins.resources.stub.MavenProjectBasicStub;
import org.codehaus.plexus.util.FileUtils;

public class MavenProjectBuildStub
extends MavenProjectBasicStub {
    protected Build build = new Build();
    protected String srcDirectory;
    protected String targetDirectory;
    protected String buildDirectory;
    protected String outputDirectory;
    protected String testOutputDirectory;
    protected String resourcesDirectory;
    protected String testResourcesDirectory;
    protected String targetResourceDirectory;
    protected String targetTestResourcesDirectory;
    protected ArrayList<String> fileList = new ArrayList();
    protected ArrayList<String> directoryList = new ArrayList();
    protected HashMap<String, String> dataMap = new HashMap();

    public MavenProjectBuildStub(String key) throws Exception {
        super(key);
        this.setupBuild();
    }

    public void addDirectory(String name) {
        if (this.isValidPath(name)) {
            this.directoryList.add(name);
        }
    }

    public void setOutputDirectory(String dir) {
        this.outputDirectory = this.buildDirectory + "/" + dir;
        this.build.setOutputDirectory(this.outputDirectory);
    }

    public void addFile(String name) {
        if (this.isValidPath(name)) {
            this.fileList.add(name);
        }
    }

    public void addFile(String name, String data) {
        File fileName = new File(name);
        this.addFile(name);
        this.dataMap.put(fileName.getName(), data);
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getTestOutputDirectory() {
        return this.testOutputDirectory;
    }

    public String getResourcesDirectory() {
        return this.resourcesDirectory;
    }

    public String getTestResourcesDirectory() {
        return this.testResourcesDirectory;
    }

    public Build getBuild() {
        return this.build;
    }

    private boolean isValidPath(String path) {
        boolean bRetVal = true;
        if (path.startsWith("c:") || path.startsWith("..") || path.startsWith("/") || path.startsWith("\\")) {
            bRetVal = false;
        }
        return bRetVal;
    }

    private void setupBuild() {
        this.srcDirectory = this.testRootDir + "/src";
        this.buildDirectory = this.testRootDir + "/target";
        this.outputDirectory = this.buildDirectory + "/classes";
        this.testOutputDirectory = this.buildDirectory + "/test-classes";
        this.resourcesDirectory = this.srcDirectory + "/main/resources/";
        this.testResourcesDirectory = this.srcDirectory + "/test/resources/";
        this.build.setDirectory(this.buildDirectory);
        this.build.setOutputDirectory(this.outputDirectory);
        this.build.setTestOutputDirectory(this.testOutputDirectory);
    }

    public void cleanBuildEnvironment() throws Exception {
        if (FileUtils.fileExists((String)this.resourcesDirectory)) {
            FileUtils.deleteDirectory((String)this.resourcesDirectory);
        }
        if (FileUtils.fileExists((String)this.testResourcesDirectory)) {
            FileUtils.deleteDirectory((String)this.testResourcesDirectory);
        }
        if (FileUtils.fileExists((String)this.outputDirectory)) {
            FileUtils.deleteDirectory((String)this.outputDirectory);
        }
        if (FileUtils.fileExists((String)this.testOutputDirectory)) {
            FileUtils.deleteDirectory((String)this.testOutputDirectory);
        }
    }

    public void setupBuildEnvironment() throws Exception {
        if (!FileUtils.fileExists((String)this.resourcesDirectory)) {
            FileUtils.mkdir((String)this.resourcesDirectory);
        }
        if (!FileUtils.fileExists((String)this.testResourcesDirectory)) {
            FileUtils.mkdir((String)this.testResourcesDirectory);
        }
        this.createDirectories(this.resourcesDirectory, this.testResourcesDirectory);
        this.createFiles(this.resourcesDirectory, this.testResourcesDirectory);
        if (!FileUtils.fileExists((String)this.outputDirectory)) {
            FileUtils.mkdir((String)this.outputDirectory);
        }
        if (!FileUtils.fileExists((String)this.testOutputDirectory)) {
            FileUtils.mkdir((String)this.testOutputDirectory);
        }
    }

    private void createDirectories(String parent, String testparent) {
        for (String directory : this.directoryList) {
            File currentDirectory = new File(parent, "/" + directory);
            if (!currentDirectory.exists()) {
                currentDirectory.mkdirs();
            }
            if ((currentDirectory = new File(testparent, "/" + directory)).exists()) continue;
            currentDirectory.mkdirs();
        }
    }

    private void createFiles(String parent, String testparent) throws IOException {
        for (String file : this.fileList) {
            File currentFile = new File(parent, file);
            if (!currentFile.getParentFile().exists()) {
                currentFile.getParentFile().mkdirs();
            }
            if (!currentFile.exists()) {
                try {
                    currentFile.createNewFile();
                    this.populateFile(currentFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!(currentFile = new File(testparent, file)).getParentFile().exists()) {
                currentFile.getParentFile().mkdirs();
            }
            if (currentFile.exists()) continue;
            currentFile.createNewFile();
            this.populateFile(currentFile);
        }
    }

    private void populateFile(File file) throws IOException {
        String data = this.dataMap.get(file.getName());
        if (data != null && file.exists()) {
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                outputStream.write(data.getBytes());
            }
        }
    }
}

