/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.repository.ScmRepository;

@Mojo(name="checkin", aggregator=true)
public class CheckinMojo
extends AbstractScmMojo {
    @Parameter(property="message")
    private String message;
    @Parameter(property="connectionType", defaultValue="developerConnection")
    private String connectionType;
    @Parameter(property="scmVersionType")
    private String scmVersionType;
    @Parameter(property="scmVersion")
    private String scmVersion;

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        this.setConnectionType(this.connectionType);
        try {
            ScmRepository repository = this.getScmRepository();
            CheckInScmResult result = this.getScmManager().checkIn(repository, this.getFileSet(), this.getScmVersion(this.scmVersionType, this.scmVersion), this.message);
            this.checkResult((ScmResult)result);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot run checkin command : ", (Exception)e);
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Cannot run checkin command : ", (Exception)((Object)e));
        }
    }
}

