/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.NoSuchCommandScmException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.command.edit.EditScmResult;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.command.login.LoginScmResult;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.command.unedit.UnEditScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.log.ScmLogDispatcher;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.scm.repository.UnknownRepositoryStructure;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractScmProvider
implements ScmProvider {
    private ScmLogDispatcher logDispatcher = new ScmLogDispatcher();

    public String getScmSpecificFilename() {
        return null;
    }

    public String sanitizeTagName(String tag) {
        return tag;
    }

    public boolean validateTagName(String tag) {
        return true;
    }

    public List validateScmUrl(String scmSpecificUrl, char delimiter) {
        ArrayList<String> messages = new ArrayList<String>();
        try {
            this.makeProviderScmRepository(scmSpecificUrl, delimiter);
        }
        catch (ScmRepositoryException e) {
            messages.add(e.getMessage());
        }
        return messages;
    }

    public boolean requiresEditMode() {
        return false;
    }

    public AddScmResult add(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        return this.add(repository, fileSet, (String)null);
    }

    public AddScmResult add(ScmRepository repository, ScmFileSet fileSet, String message) throws ScmException {
        this.login(repository, fileSet);
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.MESSAGE, message == null ? "" : message);
        parameters.setString(CommandParameter.BINARY, "false");
        return this.add(repository, fileSet, parameters);
    }

    protected AddScmResult add(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        throw new NoSuchCommandScmException("add");
    }

    public ChangeLogScmResult changeLog(ScmRepository repository, ScmFileSet fileSet, Date startDate, Date endDate, int numDays, String branch) throws ScmException {
        return this.changeLog(repository, fileSet, startDate, endDate, numDays, branch, null);
    }

    public ChangeLogScmResult changeLog(ScmRepository repository, ScmFileSet fileSet, Date startDate, Date endDate, int numDays, String branch, String datePattern) throws ScmException {
        this.login(repository, fileSet);
        CommandParameters parameters = new CommandParameters();
        parameters.setDate(CommandParameter.START_DATE, startDate);
        parameters.setDate(CommandParameter.END_DATE, endDate);
        parameters.setInt(CommandParameter.NUM_DAYS, numDays);
        parameters.setString(CommandParameter.BRANCH, branch);
        parameters.setString(CommandParameter.CHANGELOG_DATE_PATTERN, datePattern);
        return this.changelog(repository, fileSet, parameters);
    }

    public ChangeLogScmResult changeLog(ScmRepository repository, ScmFileSet fileSet, String startTag, String endTag) throws ScmException {
        return this.changeLog(repository, fileSet, startTag, endTag, null);
    }

    public ChangeLogScmResult changeLog(ScmRepository repository, ScmFileSet fileSet, String startTag, String endTag, String datePattern) throws ScmException {
        this.login(repository, fileSet);
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.START_TAG, startTag);
        parameters.setString(CommandParameter.END_TAG, endTag);
        parameters.setString(CommandParameter.CHANGELOG_DATE_PATTERN, datePattern);
        return this.changelog(repository, fileSet, parameters);
    }

    protected ChangeLogScmResult changelog(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        throw new NoSuchCommandScmException("changelog");
    }

    public CheckInScmResult checkIn(ScmRepository repository, ScmFileSet fileSet, String tag, String message) throws ScmException {
        this.login(repository, fileSet);
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.TAG, tag);
        parameters.setString(CommandParameter.MESSAGE, message);
        return this.checkin(repository, fileSet, parameters);
    }

    protected CheckInScmResult checkin(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        throw new NoSuchCommandScmException("checkin");
    }

    public CheckOutScmResult checkOut(ScmRepository repository, ScmFileSet fileSet, String tag) throws ScmException {
        this.login(repository, fileSet);
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.TAG, tag);
        return this.checkout(repository, fileSet, parameters);
    }

    protected CheckOutScmResult checkout(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        throw new NoSuchCommandScmException("checkout");
    }

    public DiffScmResult diff(ScmRepository repository, ScmFileSet fileSet, String startRevision, String endRevision) throws ScmException {
        this.login(repository, fileSet);
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.START_REVISION, startRevision);
        parameters.setString(CommandParameter.END_REVISION, endRevision);
        return this.diff(repository, fileSet, parameters);
    }

    protected DiffScmResult diff(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        throw new NoSuchCommandScmException("diff");
    }

    private void login(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        LoginScmResult result = this.login(repository, fileSet, new CommandParameters());
        if (!result.isSuccess()) {
            throw new ScmException("Can't login.\n" + result.getCommandOutput());
        }
    }

    protected LoginScmResult login(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return new LoginScmResult(null, null, null, true);
    }

    public RemoveScmResult remove(ScmRepository repository, ScmFileSet fileSet, String message) throws ScmException {
        this.login(repository, fileSet);
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.MESSAGE, message == null ? "" : message);
        return this.remove(repository, fileSet, parameters);
    }

    protected RemoveScmResult remove(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        throw new NoSuchCommandScmException("remove");
    }

    public StatusScmResult status(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        this.login(repository, fileSet);
        CommandParameters parameters = new CommandParameters();
        return this.status(repository, fileSet, parameters);
    }

    protected StatusScmResult status(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        throw new NoSuchCommandScmException("status");
    }

    public TagScmResult tag(ScmRepository repository, ScmFileSet fileSet, String tag) throws ScmException {
        this.login(repository, fileSet);
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.TAG, tag);
        return this.tag(repository, fileSet, parameters);
    }

    protected TagScmResult tag(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        throw new NoSuchCommandScmException("tag");
    }

    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, String tag) throws ScmException {
        return this.update(repository, fileSet, tag, "");
    }

    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, String tag, String datePattern) throws ScmException {
        this.login(repository, fileSet);
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.TAG, tag);
        parameters.setString(CommandParameter.CHANGELOG_DATE_PATTERN, datePattern);
        return this.update(repository, fileSet, parameters);
    }

    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, String tag, Date lastUpdate) throws ScmException {
        return this.update(repository, fileSet, tag, lastUpdate, null);
    }

    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, String tag, Date lastUpdate, String datePattern) throws ScmException {
        this.login(repository, fileSet);
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.TAG, tag);
        if (lastUpdate != null) {
            parameters.setDate(CommandParameter.START_DATE, lastUpdate);
        }
        parameters.setString(CommandParameter.CHANGELOG_DATE_PATTERN, datePattern);
        return this.update(repository, fileSet, parameters);
    }

    protected UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        throw new NoSuchCommandScmException("update");
    }

    public EditScmResult edit(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        this.login(repository, fileSet);
        CommandParameters parameters = new CommandParameters();
        return this.edit(repository, fileSet, parameters);
    }

    protected EditScmResult edit(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        this.getLogger().warn("Provider " + repository.getProvider() + " does not support edit operation.");
        return new EditScmResult("", null, null, true);
    }

    public UnEditScmResult unedit(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        this.login(repository, fileSet);
        CommandParameters parameters = new CommandParameters();
        return this.unedit(repository, fileSet, parameters);
    }

    protected UnEditScmResult unedit(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        this.getLogger().warn("Provider " + repository.getProvider() + " does not support unedit operation.");
        return new UnEditScmResult("", null, null, true);
    }

    protected ListScmResult list(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        throw new NoSuchCommandScmException("list");
    }

    public ListScmResult list(ScmRepository repository, ScmFileSet fileSet, boolean recursive, String tag) throws ScmException {
        this.login(repository, fileSet);
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.RECURSIVE, Boolean.toString(recursive));
        if (StringUtils.isNotEmpty((String)tag)) {
            parameters.setString(CommandParameter.TAG, tag);
        }
        return this.list(repository, fileSet, parameters);
    }

    public void addListener(ScmLogger logger) {
        this.logDispatcher.addListener(logger);
    }

    public ScmLogger getLogger() {
        return this.logDispatcher;
    }

    public ScmProviderRepository makeProviderScmRepository(File path) throws ScmRepositoryException, UnknownRepositoryStructure {
        throw new UnknownRepositoryStructure();
    }
}

