/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.bazaar;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.log.DefaultLog;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.bazaar.BazaarConfig;
import org.apache.maven.scm.provider.bazaar.command.BazaarConsumer;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public final class BazaarUtils {
    private static final Map<String, List<Integer>> EXITCODEMAP = new HashMap<String, List<Integer>>();
    private static final List<Integer> DEFAULTEEXITCODES = new ArrayList<Integer>();

    private BazaarUtils() {
    }

    public static ScmResult execute(BazaarConsumer consumer, ScmLogger logger, File workingDir, String[] cmdAndArgs) throws ScmException {
        try {
            Commandline cmd = BazaarUtils.buildCmd(workingDir, cmdAndArgs);
            if (logger.isInfoEnabled()) {
                logger.info("EXECUTING: " + cmd);
            }
            int exitCode = BazaarUtils.executeCmd(consumer, cmd);
            List<Integer> exitCodes = DEFAULTEEXITCODES;
            if (EXITCODEMAP.containsKey(cmdAndArgs[0])) {
                exitCodes = EXITCODEMAP.get(cmdAndArgs[0]);
            }
            boolean success = exitCodes.contains(exitCode);
            String providerMsg = "Execution of bazaar command succeded";
            if (!success) {
                BazaarConfig config = new BazaarConfig(workingDir);
                providerMsg = "\nEXECUTION FAILED\n  Execution of cmd : " + cmdAndArgs[0] + " failed with exit code: " + exitCode + "." + "\n  Working directory was: " + "\n    " + workingDir.getAbsolutePath() + config.toString(workingDir) + "\n";
                if (logger.isErrorEnabled()) {
                    logger.error(providerMsg);
                }
            }
            return new ScmResult(cmd.toString(), providerMsg, consumer.getStdErr(), success);
        }
        catch (ScmException se) {
            String msg = "EXECUTION FAILED\n  Execution failed before invoking the Bazaar command. Last exception:\n    " + se.getMessage();
            if (se.getCause() != null) {
                msg = msg + "\n  Nested exception:\n    " + se.getCause().getMessage();
            }
            if (logger.isErrorEnabled()) {
                logger.error(msg);
            }
            throw se;
        }
    }

    static Commandline buildCmd(File workingDir, String[] cmdAndArgs) throws ScmException {
        boolean success;
        Commandline cmd = new Commandline();
        cmd.setExecutable("bzr");
        cmd.setWorkingDirectory(workingDir.getAbsolutePath());
        cmd.addArguments(cmdAndArgs);
        if (!workingDir.exists() && !(success = workingDir.mkdirs())) {
            String msg = "Working directory did not exist and it couldn't be created: " + workingDir;
            throw new ScmException(msg);
        }
        return cmd;
    }

    static int executeCmd(BazaarConsumer consumer, Commandline cmd) throws ScmException {
        int exitCode;
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)consumer, (StreamConsumer)consumer);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Command could not be executed: " + cmd, (Throwable)ex);
        }
        return exitCode;
    }

    public static ScmResult execute(File workingDir, String[] cmdAndArgs) throws ScmException {
        DefaultLog logger = new DefaultLog();
        return BazaarUtils.execute(new BazaarConsumer((ScmLogger)logger), (ScmLogger)logger, workingDir, cmdAndArgs);
    }

    public static String[] expandCommandLine(String[] cmdAndArgs, ScmFileSet additionalFiles) {
        List files = additionalFiles.getFileList();
        String[] cmd = new String[files.size() + cmdAndArgs.length];
        System.arraycopy(cmdAndArgs, 0, cmd, 0, cmdAndArgs.length);
        for (int i = 0; i < files.size(); ++i) {
            String file;
            cmd[i + cmdAndArgs.length] = file = ((File)files.get(i)).getPath().replace('\\', File.separatorChar);
        }
        return cmd;
    }

    public static int getCurrentRevisionNumber(ScmLogger logger, File workingDir) throws ScmException {
        String[] revCmd = new String[]{"revno"};
        BazaarRevNoConsumer consumer = new BazaarRevNoConsumer(logger);
        BazaarUtils.execute(consumer, logger, workingDir, revCmd);
        return consumer.getCurrentRevisionNumber();
    }

    static {
        DEFAULTEEXITCODES.add(0);
        ArrayList<Integer> diffExitCodes = new ArrayList<Integer>();
        diffExitCodes.add(0);
        diffExitCodes.add(1);
        diffExitCodes.add(2);
        EXITCODEMAP.put("diff", diffExitCodes);
    }

    private static class BazaarRevNoConsumer
    extends BazaarConsumer {
        private int revNo;

        BazaarRevNoConsumer(ScmLogger logger) {
            super(logger);
        }

        @Override
        public void doConsume(ScmFileStatus status, String line) {
            try {
                this.revNo = Integer.valueOf(line);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        int getCurrentRevisionNumber() {
            return this.revNo;
        }
    }
}

