package org.apache.maven.scm.provider.cvslib;

/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.codehaus.plexus.util.cli.StreamConsumer;

import java.util.ArrayList;
import java.util.List;

/**
 * @deprecated 
 * @author <a href="mailto:trygvis@inamo.no">Trygve Laugst&oslash;l</a>
 * @author <a href="mailto:trygvis@inamo.no">Trygve Laugst&oslash;l</a>
 * @version $Id: AbstractCvsConsumer.java 191730 2005-06-21 21:35:52Z evenisse $
 */
public class AbstractCvsConsumer
    implements StreamConsumer
{
    private List files = new ArrayList();

    private List allowedCodes = new ArrayList();

    private ScmLogger logger;

    public AbstractCvsConsumer( ScmLogger logger )
    {
        this.logger = logger;
    }

    // ----------------------------------------------------------------------
    // StreamConsumer Implementation
    // ----------------------------------------------------------------------

    public void consumeLine( String line )
    {
        if ( line.length() < 3 )
        {
            getLogger().warn( "Unable to parse output from command: line length must be bigger than 3." );
        }

        String status = line.substring( 0, 2 );

        String file = line.substring( 2 );

        if ( !allowedCodes.contains( status ) )
        {
            getLogger().warn( "Unexpected file status: '" + status.charAt( 0 ) + "'." );

            return;
        }

        if ( status.equals( "U " ) )
        {
            files.add( new ScmFile( file, ScmFileStatus.UPDATED ) );
        }
        else if ( status.equals( "P " ) )
        {
            files.add( new ScmFile( file, ScmFileStatus.PATCHED ) );
        }
        else if ( status.equals( "C " ) )
        {
            files.add( new ScmFile( file, ScmFileStatus.CONFLICT ) );
        }
        else
        {
            getLogger().warn( "Unknown status: '" + status + "'." );
        }
    }

    // ----------------------------------------------------------------------
    //
    // ----------------------------------------------------------------------

    protected ScmLogger getLogger()
    {
        return this.logger;
    }

    public List getFiles()
    {
        return files;
    }

    public void allowCode( char code )
    {
        allowedCodes.add( Character.toString( Character.toUpperCase( code ) ) + " " );
    }
}
