package org.apache.maven.scm.provider.cvslib.command.login;

/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.login.AbstractLoginCommand;
import org.apache.maven.scm.login.LoginScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;

import java.io.IOException;

/**
 * @author <a href="mailto:evenisse@apache.org">Emmanuel Venisse</a>
 * @version $Id: CvsLoginCommand.java 355094 2005-12-08 14:04:37Z evenisse $
 */
public class CvsLoginCommand
    extends AbstractLoginCommand
{
    /**
     * @see org.apache.maven.scm.login.AbstractLoginCommand#executeLoginCommand(org.apache.maven.scm.provider.ScmProviderRepository, org.apache.maven.scm.CommandParameters)
     */
    public LoginScmResult executeLoginCommand( ScmProviderRepository repository, ScmFileSet fileSet,
                                               CommandParameters parameters )
        throws ScmException
    {
        CvsScmProviderRepository repo = (CvsScmProviderRepository) repository;

        if ( !"pserver".equals( repo.getTransport() ) )
        {
            return new LoginScmResult( null, "The cvs login ignored for " + repo.getTransport() + ".", "", true );
        }

        CvsPass passGenerator = new CvsPass( getLogger() );

        passGenerator.setCvsroot( repo.getCvsRootForCvsPass() );

        passGenerator.setPassword( repo.getPassword() );
        try
        {
            passGenerator.execute();
        }
        catch ( IOException e )
        {
            throw new ScmException( "Error while executing cvs login command.", e );
        }

        return new LoginScmResult( null, "The cvs command succeed.", "", true );
    }
}
