/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.command.checkout;

import java.io.File;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.cvslib.AbstractCvsScmTest;

public class CvsCheckoutCommandTest
extends AbstractCvsScmTest {
    protected String getModule() {
        return "test-repo/checkout";
    }

    public void testCheckOutWithoutTag() throws Exception {
        ScmManager scmManager = this.getScmManager();
        CheckOutScmResult result = scmManager.getProviderByRepository(this.getScmRepository()).checkOut(this.getScmRepository(), this.getScmFileSet(), null);
        if (!result.isSuccess()) {
            CvsCheckoutCommandTest.fail((String)(result.getProviderMessage() + "\n" + result.getCommandOutput()));
        }
        List files = result.getCheckedOutFiles();
        CvsCheckoutCommandTest.assertNotNull((Object)files);
        CvsCheckoutCommandTest.assertEquals((int)3, (int)files.size());
        this.assertCheckedOutFile(files, 0, "/Foo.java", ScmFileStatus.UPDATED);
        this.assertCheckedOutFile(files, 1, "/Readme.txt", ScmFileStatus.UPDATED);
        this.assertCheckedOutFile(files, 2, "/src/java/org/apache/maven/MavenUtils.java", ScmFileStatus.UPDATED);
    }

    public void testCheckOutWithTag() throws Exception {
        ScmManager scmManager = this.getScmManager();
        CheckOutScmResult result = scmManager.getProviderByRepository(this.getScmRepository()).checkOut(this.getScmRepository(), this.getScmFileSet(), "MAVEN_1_0");
        if (!result.isSuccess()) {
            CvsCheckoutCommandTest.fail((String)(result.getProviderMessage() + "\n" + result.getCommandOutput()));
        }
        List files = result.getCheckedOutFiles();
        CvsCheckoutCommandTest.assertNotNull((Object)files);
        CvsCheckoutCommandTest.assertEquals((int)1, (int)files.size());
        File mavenUtils = this.assertCheckedOutFile(files, 0, "/src/java/org/apache/maven/MavenUtils.java", ScmFileStatus.UPDATED);
        this.assertBetween(38403L, 39511L, mavenUtils.length());
    }

    private File assertCheckedOutFile(List files, int i, String fileName, ScmFileStatus status) throws Exception {
        File file = new File(this.getWorkingDirectory(), fileName);
        CvsCheckoutCommandTest.assertTrue((String)(file.getAbsolutePath() + " file doesn't exist."), (boolean)file.exists());
        ScmFile coFile = (ScmFile)files.get(i);
        CvsCheckoutCommandTest.assertSame((Object)status, (Object)coFile.getStatus());
        this.assertPath(fileName, coFile.getPath());
        return file;
    }
}

