/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.command.update;

import java.io.File;
import java.io.FileWriter;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.cvslib.AbstractCvsScmTest;
import org.apache.maven.scm.provider.cvslib.CvsScmTestUtils;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.FileUtils;

public class CvsUpdateCommandTest
extends AbstractCvsScmTest {
    private File repository;
    private File workingDirectory;
    private File assertionDirectory;

    public void setUp() throws Exception {
        super.setUp();
        this.repository = CvsUpdateCommandTest.getTestFile((String)"target/update-test/repository");
        this.workingDirectory = CvsUpdateCommandTest.getTestFile((String)"target/update-test/working-directory");
        this.assertionDirectory = CvsUpdateCommandTest.getTestFile((String)"target/update-test/assertion-directory");
        CvsScmTestUtils.initRepo(this.repository, this.workingDirectory, this.assertionDirectory);
    }

    protected String getModule() {
        return "test-repo/update";
    }

    public void testCvsUpdate() throws Exception {
        ScmManager scmManager = this.getScmManager();
        String scmUrl = CvsScmTestUtils.getScmUrl(this.repository, this.getModule());
        String arguments = "-f -d " + this.repository.getAbsolutePath() + " " + "co -d " + this.workingDirectory.getName() + " " + this.getModule();
        CvsScmTestUtils.executeCVS(this.workingDirectory.getParentFile(), arguments);
        arguments = "-f -d " + this.repository.getAbsolutePath() + " " + "co -d " + this.assertionDirectory.getName() + " " + this.getModule();
        CvsScmTestUtils.executeCVS(this.assertionDirectory.getParentFile(), arguments);
        ScmRepository scmRepository = scmManager.makeScmRepository(scmUrl);
        UpdateScmResult result = scmManager.getProviderByRepository(scmRepository).update(scmRepository, new ScmFileSet(this.assertionDirectory), null);
        CvsUpdateCommandTest.assertNotNull((Object)result);
        if (!result.isSuccess()) {
            System.out.println("result.providerMessage: " + result.getProviderMessage());
            System.out.println("result.commandOutput: " + result.getCommandOutput());
            CvsUpdateCommandTest.fail((String)"Command failed");
        }
        CvsUpdateCommandTest.assertNull((Object)result.getProviderMessage());
        CvsUpdateCommandTest.assertNull((Object)result.getCommandOutput());
        CvsUpdateCommandTest.assertNotNull((Object)result.getUpdatedFiles());
        CvsUpdateCommandTest.assertEquals((int)0, (int)result.getUpdatedFiles().size());
        File fooJava = new File(this.workingDirectory, "Foo.java");
        String content = FileUtils.fileRead((File)fooJava);
        FileWriter writer = new FileWriter(fooJava);
        writer.write(content + System.getProperty("line.separator"));
        writer.write("extra line");
        writer.close();
        writer = new FileWriter(new File(this.workingDirectory, "New.txt"));
        writer.write("new file");
        writer.close();
        arguments = "-f -d " + this.repository.getAbsolutePath() + " add New.txt";
        CvsScmTestUtils.executeCVS(this.workingDirectory, arguments);
        arguments = "-f -d " + this.repository.getAbsolutePath() + " commit -m .";
        CvsScmTestUtils.executeCVS(this.workingDirectory, arguments);
        result = scmManager.getProviderByRepository(scmRepository).update(scmRepository, new ScmFileSet(this.assertionDirectory), null);
        CvsUpdateCommandTest.assertNotNull((Object)result);
        if (!result.isSuccess()) {
            System.out.println("result.providerMessage: " + result.getProviderMessage());
            System.out.println("result.commandOutput: " + result.getCommandOutput());
            CvsUpdateCommandTest.fail((String)"Command failed");
        }
        CvsUpdateCommandTest.assertNull((Object)result.getProviderMessage());
        CvsUpdateCommandTest.assertNull((Object)result.getCommandOutput());
        CvsUpdateCommandTest.assertNotNull((Object)result.getUpdatedFiles());
        CvsUpdateCommandTest.assertEquals((int)2, (int)result.getUpdatedFiles().size());
        ScmFile file1 = (ScmFile)result.getUpdatedFiles().get(0);
        this.assertPath("Foo.java", file1.getPath());
        CvsUpdateCommandTest.assertEquals((Object)ScmFileStatus.UPDATED, (Object)file1.getStatus());
        ScmFile file2 = (ScmFile)result.getUpdatedFiles().get(1);
        this.assertPath("New.txt", file2.getPath());
        CvsUpdateCommandTest.assertEquals((Object)ScmFileStatus.UPDATED, (Object)file2.getStatus());
    }
}

