/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git;

import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public final class GitScmTestUtils {
    private GitScmTestUtils() {
    }

    public static void initRepo(File repository, File workingDirectory, File assertionDirectory) throws IOException {
        GitScmTestUtils.initRepo("src/test/repository/", repository, workingDirectory);
        FileUtils.deleteDirectory((File)assertionDirectory);
        Assert.assertTrue((boolean)assertionDirectory.mkdirs());
    }

    public static void initRepo(String source, File repository, File workingDirectory) throws IOException {
        File src = PlexusTestCase.getTestFile((String)source);
        FileUtils.deleteDirectory((File)repository);
        Assert.assertTrue((boolean)repository.mkdirs());
        FileUtils.copyDirectoryStructure((File)src, (File)repository);
        FileUtils.deleteDirectory((File)workingDirectory);
        Assert.assertTrue((boolean)workingDirectory.mkdirs());
    }

    public static String getScmUrl(File repositoryRootFile) throws CommandLineException {
        String repositoryRoot = repositoryRootFile.getAbsolutePath();
        if ("true".equals(System.getProperty("cygwin"))) {
            Commandline cl = new Commandline();
            cl.setExecutable("cygpath");
            cl.createArgument().setValue("--unix");
            cl.createArgument().setValue(repositoryRoot);
            CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
            int exitValue = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, null);
            if (exitValue != 0) {
                throw new CommandLineException("Unable to convert cygwin path, exit code = " + exitValue);
            }
            repositoryRoot = stdout.getOutput().trim();
        } else if (System.getProperty("os.name").startsWith("Windows")) {
            repositoryRoot = "/" + StringUtils.replace((String)repositoryRoot, (String)"\\", (String)"/");
        }
        return "scm:git:file://" + repositoryRoot;
    }
}

