/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.junit.Assert;

public final class GitScmTestUtils {
    private GitScmTestUtils() {
    }

    public static void initRepo(File repository, File workingDirectory, File assertionDirectory) throws IOException {
        GitScmTestUtils.initRepo("src/test/repository/", repository, workingDirectory);
        FileUtils.deleteDirectory((File)assertionDirectory);
        Assert.assertTrue((boolean)assertionDirectory.mkdirs());
    }

    public static void initRepo(String source, File repository, File workingDirectory) throws IOException {
        File src = PlexusTestCase.getTestFile((String)source);
        FileUtils.deleteDirectory((File)repository);
        Assert.assertTrue((boolean)repository.mkdirs());
        FileUtils.copyDirectoryStructure((File)src, (File)repository);
        File dotGitDirectory = new File(src, "dotgit");
        if (dotGitDirectory.exists()) {
            FileUtils.copyDirectoryStructure((File)dotGitDirectory, (File)new File(repository, ".git"));
        }
        FileUtils.deleteDirectory((File)workingDirectory);
        Assert.assertTrue((boolean)workingDirectory.mkdirs());
    }

    public static String getScmUrl(File repositoryRootFile, String provider) throws CommandLineException {
        return "scm:" + provider + ":" + repositoryRootFile.toPath().toAbsolutePath().toUri().toASCIIString();
    }

    public static void deleteAllDirectories(File startDirectory, String pattern) throws IOException {
        if (startDirectory.isDirectory()) {
            File[] childs = startDirectory.listFiles();
            for (int i = 0; i < childs.length; ++i) {
                File child = childs[i];
                if (!child.isDirectory()) continue;
                if (child.getName().equals(pattern)) {
                    FileUtils.deleteDirectory((File)child);
                    continue;
                }
                GitScmTestUtils.deleteAllDirectories(child, pattern);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultUser(File repositoryRootFile) {
        File gitConfigFile = new File(new File(repositoryRootFile, ".git"), "config");
        FileWriter fw = null;
        try {
            fw = new FileWriter(gitConfigFile, true);
            fw.append("[user]\n");
            fw.append("\tname = John Doe\n");
            fw.append("\temail = john.doe@nowhere.com\n");
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            System.err.println("cannot setup a default user for tests purpose inside " + gitConfigFile);
            e.printStackTrace();
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

