/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.command.changelog;

import java.io.File;
import java.util.List;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmRevision;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogScmRequest;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.git.GitScmTestUtils;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.tck.command.changelog.ChangeLogCommandTckTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public abstract class GitChangeLogCommandTckTest
extends ChangeLogCommandTckTest {
    public static final long SLEEP_TIME_IN_MILLIS = 250L;

    public void initRepo() throws Exception {
        GitScmTestUtils.initRepo("src/test/resources/linear-changelog/", this.getRepositoryRoot(), this.getWorkingCopy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CheckOutScmResult checkOut(File workingDirectory, ScmRepository repository) throws Exception {
        try {
            CheckOutScmResult checkOutScmResult = super.checkOut(workingDirectory, repository);
            return checkOutScmResult;
        }
        finally {
            GitScmTestUtils.setDefaultUser(workingDirectory);
        }
    }

    public void testChangeLogCommandFromHeadAncestorAndHead() throws Exception {
        Thread.sleep(250L);
        ScmRepository scmRepository = this.getScmRepository();
        ScmProvider provider = this.getScmManager().getProviderByRepository(scmRepository);
        ScmFileSet fileSet = new ScmFileSet(this.getWorkingCopy());
        ChangeLogScmRequest clr = new ChangeLogScmRequest(scmRepository, fileSet);
        String startVersion = "HEAD~1";
        clr.setStartRevision((ScmVersion)new ScmRevision(startVersion));
        String endVersion = "HEAD";
        clr.setEndRevision((ScmVersion)new ScmRevision(endVersion));
        ChangeLogScmResult changelogResult = provider.changeLog(clr);
        List logEntries = changelogResult.getChangeLog().getChangeSets();
        GitChangeLogCommandTckTest.assertEquals((String)String.format("changelog for %s..%s returned bad number of commits", startVersion, endVersion), (int)1, (int)logEntries.size());
        MatcherAssert.assertThat((String)"bad head commit SHA1 retrieved", (Object)((ChangeSet)logEntries.get(0)).getRevision(), (Matcher)CoreMatchers.startsWith((String)"464921b"));
    }

    public void testChangeLogCommandFromHeadToHead() throws Exception {
        Thread.sleep(250L);
        ScmRepository scmRepository = this.getScmRepository();
        ScmProvider provider = this.getScmManager().getProviderByRepository(scmRepository);
        ScmFileSet fileSet = new ScmFileSet(this.getWorkingCopy());
        ChangeLogScmRequest clr = new ChangeLogScmRequest(scmRepository, fileSet);
        String startVersion = "HEAD";
        clr.setStartRevision((ScmVersion)new ScmRevision(startVersion));
        String endVersion = "HEAD";
        clr.setEndRevision((ScmVersion)new ScmRevision(endVersion));
        ChangeLogScmResult changelogResult = provider.changeLog(clr);
        List logEntries = changelogResult.getChangeLog().getChangeSets();
        GitChangeLogCommandTckTest.assertEquals((String)String.format("changelog for %s..%s returned bad number of commits", startVersion, endVersion), (int)0, (int)logEntries.size());
    }

    public void testChangeLogCommandFromUndefinedToHead() throws Exception {
        Thread.sleep(250L);
        ScmRepository scmRepository = this.getScmRepository();
        ScmProvider provider = this.getScmManager().getProviderByRepository(scmRepository);
        ScmFileSet fileSet = new ScmFileSet(this.getWorkingCopy());
        ChangeLogScmRequest clr = new ChangeLogScmRequest(scmRepository, fileSet);
        String endVersion = "HEAD";
        clr.setEndRevision((ScmVersion)new ScmRevision(endVersion));
        ChangeLogScmResult changelogResult = provider.changeLog(clr);
        List logEntries = changelogResult.getChangeLog().getChangeSets();
        GitChangeLogCommandTckTest.assertEquals((String)String.format("changelog for ..%s returned bad number of commits", endVersion), (int)0, (int)logEntries.size());
    }

    public void testChangeLogCommandFromVersionToUndefined() throws Exception {
        Thread.sleep(250L);
        ScmRepository scmRepository = this.getScmRepository();
        ScmProvider provider = this.getScmManager().getProviderByRepository(scmRepository);
        ScmFileSet fileSet = new ScmFileSet(this.getWorkingCopy());
        ChangeLogScmRequest clr = new ChangeLogScmRequest(scmRepository, fileSet);
        String startVersion = "e3864d9";
        clr.setStartRevision((ScmVersion)new ScmRevision(startVersion));
        ChangeLogScmResult changelogResult = provider.changeLog(clr);
        List logEntries = changelogResult.getChangeLog().getChangeSets();
        GitChangeLogCommandTckTest.assertEquals((String)String.format("changelog for %s.. returned bad number of commits", startVersion), (int)2, (int)logEntries.size());
        MatcherAssert.assertThat((String)"bad commit SHA1 retrieved", (Object)((ChangeSet)logEntries.get(0)).getRevision(), (Matcher)CoreMatchers.startsWith((String)"464921b"));
        MatcherAssert.assertThat((String)"bad commit SHA1 retrieved", (Object)((ChangeSet)logEntries.get(1)).getRevision(), (Matcher)CoreMatchers.startsWith((String)"db46d63"));
    }

    public void testChangeLogCommandFromVoneToVtwo() throws Exception {
        Thread.sleep(250L);
        ScmRepository scmRepository = this.getScmRepository();
        ScmProvider provider = this.getScmManager().getProviderByRepository(scmRepository);
        ScmFileSet fileSet = new ScmFileSet(this.getWorkingCopy());
        ChangeLogScmRequest clr = new ChangeLogScmRequest(scmRepository, fileSet);
        String startVersion = "0f1e817";
        clr.setStartRevision((ScmVersion)new ScmRevision(startVersion));
        String endVersion = "db46d63";
        clr.setEndRevision((ScmVersion)new ScmRevision(endVersion));
        ChangeLogScmResult changelogResult = provider.changeLog(clr);
        List logEntries = changelogResult.getChangeLog().getChangeSets();
        GitChangeLogCommandTckTest.assertEquals((String)String.format("changelog for %s.. returned bad number of commits", startVersion), (int)2, (int)logEntries.size());
        MatcherAssert.assertThat((String)"bad commit SHA1 retrieved", (Object)((ChangeSet)logEntries.get(0)).getRevision(), (Matcher)CoreMatchers.startsWith((String)"db46d63"));
        MatcherAssert.assertThat((String)"bad commit SHA1 retrieved", (Object)((ChangeSet)logEntries.get(1)).getRevision(), (Matcher)CoreMatchers.startsWith((String)"e3864d9"));
    }

    public void testChangeLogCommandWithStartEndInBadOrder() throws Exception {
        Thread.sleep(250L);
        ScmRepository scmRepository = this.getScmRepository();
        ScmProvider provider = this.getScmManager().getProviderByRepository(scmRepository);
        ScmFileSet fileSet = new ScmFileSet(this.getWorkingCopy());
        ChangeLogScmRequest clr = new ChangeLogScmRequest(scmRepository, fileSet);
        String startVersion = "db46d63";
        clr.setStartRevision((ScmVersion)new ScmRevision(startVersion));
        String endVersion = "0f1e817";
        clr.setEndRevision((ScmVersion)new ScmRevision(endVersion));
        ChangeLogScmResult changelogResult = provider.changeLog(clr);
        List logEntries = changelogResult.getChangeLog().getChangeSets();
        GitChangeLogCommandTckTest.assertEquals((String)String.format("changelog for %s..%s should return no commits", startVersion, endVersion), (int)0, (int)logEntries.size());
    }

    public void testChangeLogCommandFromHeadToStartOfRepository() throws Exception {
        Thread.sleep(250L);
        ScmRepository scmRepository = this.getScmRepository();
        ScmProvider provider = this.getScmManager().getProviderByRepository(scmRepository);
        ScmFileSet fileSet = new ScmFileSet(this.getWorkingCopy());
        ChangeLogScmRequest clr = new ChangeLogScmRequest(scmRepository, fileSet);
        String version = "HEAD";
        clr.setRevision((ScmVersion)new ScmRevision(version));
        ChangeLogScmResult changelogResult = provider.changeLog(clr);
        List logEntries = changelogResult.getChangeLog().getChangeSets();
        GitChangeLogCommandTckTest.assertEquals((String)String.format("changelog for %s returned bad number of commits", version), (int)5, (int)logEntries.size());
    }

    public void testChangeLogCommandFromVersionToStartOfRepository() throws Exception {
        Thread.sleep(250L);
        ScmRepository scmRepository = this.getScmRepository();
        ScmProvider provider = this.getScmManager().getProviderByRepository(scmRepository);
        ScmFileSet fileSet = new ScmFileSet(this.getWorkingCopy());
        ChangeLogScmRequest clr = new ChangeLogScmRequest(scmRepository, fileSet);
        String version = "db46d63";
        clr.setRevision((ScmVersion)new ScmRevision(version));
        ChangeLogScmResult changelogResult = provider.changeLog(clr);
        List logEntries = changelogResult.getChangeLog().getChangeSets();
        GitChangeLogCommandTckTest.assertEquals((String)String.format("changelog for %s returned bad number of commits", version), (int)4, (int)logEntries.size());
        MatcherAssert.assertThat((String)"bad commit SHA1 retrieved", (Object)((ChangeSet)logEntries.get(0)).getRevision(), (Matcher)CoreMatchers.startsWith((String)"db46d63"));
        MatcherAssert.assertThat((String)"bad commit SHA1 retrieved", (Object)((ChangeSet)logEntries.get(1)).getRevision(), (Matcher)CoreMatchers.startsWith((String)"e3864d9"));
        MatcherAssert.assertThat((String)"bad commit SHA1 retrieved", (Object)((ChangeSet)logEntries.get(2)).getRevision(), (Matcher)CoreMatchers.startsWith((String)"0f1e817"));
        MatcherAssert.assertThat((String)"bad commit SHA1 retrieved", (Object)((ChangeSet)logEntries.get(3)).getRevision(), (Matcher)CoreMatchers.startsWith((String)"e75cb5a"));
    }
}

