/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit.command.add;

import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.add.AbstractAddCommand;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.jgit.command.JGitUtils;
import org.eclipse.jgit.api.Git;

public class JGitAddCommand
extends AbstractAddCommand
implements GitCommand {
    protected ScmResult executeAddCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message, boolean binary) throws ScmException {
        if (fileSet.getFileList().isEmpty()) {
            throw new ScmException("You must provide at least one file/directory to add (e.g. -Dincludes=...)");
        }
        Git git = null;
        try {
            git = JGitUtils.openRepo(fileSet.getBasedir());
            List<ScmFile> addedFiles = JGitUtils.addAllFiles(git, fileSet);
            if (this.getLogger().isDebugEnabled()) {
                for (ScmFile scmFile : addedFiles) {
                    this.getLogger().info("added file: " + scmFile);
                }
            }
            AddScmResult addScmResult = new AddScmResult("JGit add", addedFiles);
            return addScmResult;
        }
        catch (Exception e) {
            throw new ScmException("JGit add failure!", (Throwable)e);
        }
        finally {
            JGitUtils.closeRepo(git);
        }
    }
}

