/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.csv;

import com.opencsv.CSVReader;
import java.io.IOException;
import org.apache.metamodel.csv.CsvConfiguration;
import org.apache.metamodel.csv.CsvSchema;
import org.apache.metamodel.schema.AbstractTable;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.Relationship;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.schema.TableType;
import org.apache.metamodel.schema.naming.ColumnNamingContext;
import org.apache.metamodel.schema.naming.ColumnNamingContextImpl;
import org.apache.metamodel.schema.naming.ColumnNamingSession;
import org.apache.metamodel.schema.naming.ColumnNamingStrategy;
import org.apache.metamodel.util.FileHelper;

final class CsvTable
extends AbstractTable {
    private static final long serialVersionUID = 1L;
    private final CsvSchema _schema;
    private final String _tableName;
    private Column[] _columns;

    public CsvTable(CsvSchema schema, String tableName, String[] columnNames) {
        this(schema, tableName);
        this._columns = this.buildColumns(columnNames);
    }

    public CsvTable(CsvSchema schema, String tableName) {
        this._schema = schema;
        this._tableName = tableName;
    }

    public String getName() {
        if (this._tableName == null) {
            String schemaName = this._schema.getName();
            return schemaName.substring(0, schemaName.length() - 4);
        }
        return this._tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Column[] getColumns() {
        if (this._columns == null) {
            CsvTable csvTable = this;
            synchronized (csvTable) {
                if (this._columns == null) {
                    this._columns = this.buildColumns();
                }
            }
        }
        return this._columns;
    }

    private Column[] buildColumns() {
        Column[] columnArray;
        CSVReader reader = null;
        try {
            reader = this._schema.getDataContext().createCsvReader(0);
            int columnNameLineNumber = this._schema.getDataContext().getConfiguration().getColumnNameLineNumber();
            for (int i = 1; i < columnNameLineNumber; ++i) {
                reader.readNext();
            }
            String[] columnHeaders = reader.readNext();
            reader.close();
            columnArray = this.buildColumns(columnHeaders);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("Exception reading from resource: " + this._schema.getDataContext().getResource().getName(), e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{reader});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{reader});
        return columnArray;
    }

    private Column[] buildColumns(String[] columnNames) {
        if (columnNames == null) {
            return new Column[0];
        }
        CsvConfiguration configuration = this._schema.getDataContext().getConfiguration();
        int columnNameLineNumber = configuration.getColumnNameLineNumber();
        boolean nullable = !configuration.isFailOnInconsistentRowLength();
        ColumnNamingStrategy columnNamingStrategy = configuration.getColumnNamingStrategy();
        Column[] columns = new Column[columnNames.length];
        try (ColumnNamingSession namingSession = columnNamingStrategy.startColumnNamingSession();){
            for (int i = 0; i < columnNames.length; ++i) {
                String intrinsicColumnName = columnNameLineNumber == 0 ? null : columnNames[i];
                String columnName = namingSession.getNextColumnName((ColumnNamingContext)new ColumnNamingContextImpl((Table)this, intrinsicColumnName, i));
                MutableColumn column = new MutableColumn(columnName, ColumnType.STRING, (Table)this, i, null, null, Boolean.valueOf(nullable), null, false, null);
                columns[i] = column;
            }
        }
        return columns;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public TableType getType() {
        return TableType.TABLE;
    }

    public Relationship[] getRelationships() {
        return new Relationship[0];
    }

    public String getRemarks() {
        return null;
    }

    public String getQuote() {
        return null;
    }
}

