/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.csv;

import com.opencsv.ICSVParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.csv.CsvConfiguration;
import org.apache.metamodel.csv.CsvParserBuilder;
import org.apache.metamodel.csv.SingleLineCsvRow;
import org.apache.metamodel.data.AbstractDataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.util.FileHelper;

final class SingleLineCsvDataSet
extends AbstractDataSet {
    private final BufferedReader _reader;
    private final int _columnsInTable;
    private final boolean _failOnInconsistentRowLength;
    private final CsvParserBuilder _csvParserBuilder;
    private volatile int _rowNumber;
    private volatile Integer _rowsRemaining;
    private volatile Row _row;

    public SingleLineCsvDataSet(BufferedReader reader, List<Column> columns, Integer maxRows, int columnsInTable, CsvConfiguration csvConfiguration) {
        super(columns.stream().map(SelectItem::new).collect(Collectors.toList()));
        this._reader = reader;
        this._columnsInTable = columnsInTable;
        this._failOnInconsistentRowLength = csvConfiguration.isFailOnInconsistentRowLength();
        this._rowNumber = 0;
        this._rowsRemaining = maxRows;
        this._csvParserBuilder = new CsvParserBuilder(csvConfiguration);
    }

    public void close() {
        FileHelper.safeClose((Object[])new Object[]{this._reader});
        this._row = null;
        this._rowsRemaining = null;
    }

    public boolean next() {
        if (this._rowsRemaining != null && this._rowsRemaining > 0) {
            Integer n = this._rowsRemaining;
            Integer n2 = this._rowsRemaining = Integer.valueOf(this._rowsRemaining - 1);
            return this.nextInternal();
        }
        if (this._rowsRemaining == null) {
            return this.nextInternal();
        }
        return false;
    }

    protected DataSetHeader getHeader() {
        return super.getHeader();
    }

    protected boolean isFailOnInconsistentRowLength() {
        return this._failOnInconsistentRowLength;
    }

    protected int getColumnsInTable() {
        return this._columnsInTable;
    }

    protected ICSVParser getCsvParser() {
        return this._csvParserBuilder.build();
    }

    public boolean nextInternal() {
        if (this._reader == null) {
            return false;
        }
        try {
            String line = this._reader.readLine();
            if (line == null) {
                this.close();
                return false;
            }
            if ("".equals(line)) {
                return this.nextInternal();
            }
            ++this._rowNumber;
            this._row = new SingleLineCsvRow(this, line, this._columnsInTable, this._failOnInconsistentRowLength, this._rowNumber);
            return true;
        }
        catch (IOException e) {
            this.close();
            throw new MetaModelException("IOException occurred while reading next line of CSV resource", (Exception)e);
        }
    }

    public Row getRow() {
        return this._row;
    }
}

