/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.nativeclient;

import org.apache.metamodel.ConnectionException;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.elasticsearch.nativeclient.ElasticSearchDataContext;
import org.apache.metamodel.factory.DataContextFactory;
import org.apache.metamodel.factory.DataContextProperties;
import org.apache.metamodel.factory.ResourceFactoryRegistry;
import org.apache.metamodel.factory.UnsupportedDataContextPropertiesException;
import org.apache.metamodel.util.SimpleTableDef;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;

public class ElasticSearchDataContextFactory
implements DataContextFactory {
    public boolean accepts(DataContextProperties properties, ResourceFactoryRegistry resourceFactoryRegistry) {
        switch (properties.getDataContextType()) {
            case "elasticsearch": 
            case "es-node": 
            case "elasticsearch-node": 
            case "es-transport": 
            case "elasticsearch-transport": {
                return this.acceptsInternal(properties);
            }
        }
        return false;
    }

    private boolean acceptsInternal(DataContextProperties properties) {
        String clientType = this.getClientType(properties);
        if (clientType == null) {
            return false;
        }
        if (!("node".equals(clientType) || properties.getHostname() != null && properties.getPort() != null)) {
            return false;
        }
        if (this.getIndex(properties) == null) {
            return false;
        }
        return this.getCluster(properties) != null;
    }

    private String getClientType(DataContextProperties properties) {
        switch (properties.getDataContextType()) {
            case "elasticsearch-node": 
            case "es-node": {
                return "node";
            }
            case "elasticsearch-transport": 
            case "es-transport": {
                return "transport";
            }
        }
        String clientType = (String)properties.toMap().get("clientType");
        return clientType;
    }

    private String getIndex(DataContextProperties properties) {
        String databaseName = properties.getDatabaseName();
        if (databaseName == null) {
            return (String)properties.toMap().get("index");
        }
        return databaseName;
    }

    private String getCluster(DataContextProperties properties) {
        return (String)properties.toMap().get("cluster");
    }

    public DataContext create(DataContextProperties properties, ResourceFactoryRegistry resourceFactoryRegistry) throws UnsupportedDataContextPropertiesException, ConnectionException {
        String clientType = this.getClientType(properties);
        Client client = "node".equals(clientType) ? this.createNodeClient(properties) : this.createTransportClient(properties);
        String indexName = this.getIndex(properties);
        SimpleTableDef[] tableDefinitions = properties.getTableDefs();
        return new ElasticSearchDataContext(client, indexName, tableDefinitions);
    }

    private Client createTransportClient(DataContextProperties properties) {
        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.builder();
        settingsBuilder.put("name", "MetaModel");
        settingsBuilder.put("cluster.name", this.getCluster(properties));
        if (properties.getUsername() != null && properties.getPassword() != null) {
            settingsBuilder.put("shield.user", properties.getUsername() + ":" + properties.getPassword());
            if ("true".equals(properties.toMap().get("ssl"))) {
                if (properties.toMap().get("keystorePath") != null) {
                    settingsBuilder.put(new Object[]{"shield.ssl.keystore.path", properties.toMap().get("keystorePath")});
                    settingsBuilder.put(new Object[]{"shield.ssl.keystore.password", properties.toMap().get("keystorePassword")});
                }
                settingsBuilder.put("shield.transport.ssl", "true");
            }
        }
        Settings settings = settingsBuilder.build();
        TransportClient client = new TransportClient(settings);
        client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(properties.getHostname(), properties.getPort().intValue()));
        return client;
    }

    private Client createNodeClient(DataContextProperties properties) {
        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.builder();
        settingsBuilder.put("name", "MetaModel");
        settingsBuilder.put("shield.enabled", false);
        Settings settings = settingsBuilder.build();
        Node node = NodeBuilder.nodeBuilder().clusterName(this.getCluster(properties)).client(true).settings(settings).node();
        return node.client();
    }
}

