/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mxnet.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.mxnet.util.NativeLibraryLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.Predef$any2stringadd$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class NativeLibraryLoader$ {
    public static final NativeLibraryLoader$ MODULE$;
    private final Logger org$apache$mxnet$util$NativeLibraryLoader$$logger;
    private final String libPathInJar;
    private final File _tempDir;

    static {
        new NativeLibraryLoader$();
    }

    public Logger org$apache$mxnet$util$NativeLibraryLoader$$logger() {
        return this.org$apache$mxnet$util$NativeLibraryLoader$$logger;
    }

    private String libPathInJar() {
        return this.libPathInJar;
    }

    private File _tempDir() {
        return this._tempDir;
    }

    public void loadLibrary(String libname) throws UnsatisfiedLinkError {
        String string2;
        String mappedLibname = System.mapLibraryName(libname);
        if (mappedLibname.endsWith("dylib")) {
            this.org$apache$mxnet$util$NativeLibraryLoader$$logger().info("Replaced .dylib with .jnilib");
            string2 = mappedLibname.replace(".dylib", ".jnilib");
        } else {
            string2 = mappedLibname;
        }
        String loadLibname = string2;
        this.org$apache$mxnet$util$NativeLibraryLoader$$logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to load ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{loadLibname})));
        String libFileInJar = new StringBuilder().append((Object)this.libPathInJar()).append((Object)loadLibname).toString();
        InputStream is = this.getClass().getResourceAsStream(libFileInJar);
        if (is == null) {
            throw new UnsatisfiedLinkError(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't find the resource ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{loadLibname})));
        }
        this.org$apache$mxnet$util$NativeLibraryLoader$$logger().info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading ", " from ", " copying to ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{loadLibname, this.libPathInJar(), libname})));
        this.loadLibraryFromStream(libname, is);
    }

    private String unifyOSName(String osname) {
        Object object = osname.startsWith("Windows") ? "Windows" : BoxedUnit.UNIT;
        return osname;
    }

    private String getUnifiedOSName() {
        return this.unifyOSName(System.getProperty("os.name"));
    }

    private File createTempFile(String name) throws IOException {
        return new File(new StringBuilder().append((Object)Predef$any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(this._tempDir()), File.separator)).append((Object)name).toString());
    }

    private void loadLibraryFromStream(String libname, InputStream is) {
        try {
            File tempfile = this.createTempFile(libname);
            FileOutputStream os = new FileOutputStream(tempfile);
            this.org$apache$mxnet$util$NativeLibraryLoader$$logger().debug("tempfile.getPath() = {}", new Object[]{tempfile.getPath()});
            long savedTime = System.currentTimeMillis();
            byte[] buf = new byte[8192];
            int len = is.read(buf);
            while (len > 0) {
                ((OutputStream)os).write(buf, 0, len);
                len = is.read(buf);
            }
            os.flush();
            FileInputStream lock = new FileInputStream(tempfile);
            ((OutputStream)os).close();
            double seconds = (double)(System.currentTimeMillis() - savedTime) / 1000.0;
            this.org$apache$mxnet$util$NativeLibraryLoader$$logger().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Copying took ", " seconds."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(seconds)})));
            this.org$apache$mxnet$util$NativeLibraryLoader$$logger().debug("Loading library from {}", new Object[]{tempfile.getPath()});
            System.load(tempfile.getPath());
            ((InputStream)lock).close();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.org$apache$mxnet$util$NativeLibraryLoader$$logger().error("Couldn't load copied link file: {}", new Object[]{unsatisfiedLinkError.toString()});
            throw unsatisfiedLinkError;
        }
        catch (IOException iOException) {
            this.org$apache$mxnet$util$NativeLibraryLoader$$logger().error("Could not create the temp file: {}", new Object[]{iOException.toString()});
        }
    }

    private final File liftedTree1$1() {
        File file;
        try {
            File tempDir = File.createTempFile("mxnet", "");
            if (tempDir.delete() && tempDir.mkdir()) {
                String string2 = this.getUnifiedOSName();
                String string3 = "Windows";
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    throw new RuntimeException("Windows not supported yet.");
                }
            } else {
                throw new IOException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't create directory ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{tempDir.getAbsolutePath()})));
            }
            Runtime.getRuntime().addShutdownHook(new Thread(tempDir){
                private final File tempDir$1;

                public void run() {
                    Predef$.MODULE$.refArrayOps((Object[])this.tempDir$1.listFiles()).foreach(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(File f2) {
                            NativeLibraryLoader$.MODULE$.org$apache$mxnet$util$NativeLibraryLoader$$logger().info(new StringBuilder().append((Object)"Deleting ").append((Object)f2.getAbsolutePath()).toString());
                            if (!f2.delete()) {
                                NativeLibraryLoader$.MODULE$.org$apache$mxnet$util$NativeLibraryLoader$$logger().warn(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't delete temporary file ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{f2.getAbsolutePath()})));
                            }
                        }
                    });
                    NativeLibraryLoader$.MODULE$.org$apache$mxnet$util$NativeLibraryLoader$$logger().info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.tempDir$1.getAbsolutePath()})));
                    if (!this.tempDir$1.delete()) {
                        NativeLibraryLoader$.MODULE$.org$apache$mxnet$util$NativeLibraryLoader$$logger().warn(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't delete temporary directory ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.tempDir$1.getAbsolutePath()})));
                    }
                }
                {
                    this.tempDir$1 = tempDir$1;
                }
            });
            file = tempDir;
        }
        catch (IOException iOException) {
            this.org$apache$mxnet$util$NativeLibraryLoader$$logger().error("Couldn't create temporary directory: {}", new Object[]{iOException.getMessage()});
            file = null;
        }
        return file;
    }

    private NativeLibraryLoader$() {
        MODULE$ = this;
        this.org$apache$mxnet$util$NativeLibraryLoader$$logger = LoggerFactory.getLogger(NativeLibraryLoader.class);
        this.libPathInJar = "/lib/native/";
        this._tempDir = this.liftedTree1$1();
    }
}

