/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Starter {
    public static final String PARAMETER_NAME = "mainclass";

    public static void main(String[] args2) {
        String classname = System.getProperty(PARAMETER_NAME);
        CmdLineParser parser = null;
        boolean classHasArgument = false;
        boolean classHasOptions = false;
        if (classname == null || "".equals(classname)) {
            System.err.println("The system property 'mainclass' must contain the classname to start.");
            System.exit(-1);
        }
        try {
            Method m;
            Class<?> clazz2 = Class.forName(classname);
            Object bean = clazz2.newInstance();
            parser = new CmdLineParser(bean);
            classHasArgument = Starter.hasAnnotation(clazz2, Argument.class);
            classHasOptions = Starter.hasAnnotation(clazz2, Option.class);
            parser.parseArgument(args2);
            boolean couldInvoke = false;
            try {
                m = clazz2.getMethod("run", null);
                m.invoke(bean, (Object[])null);
                couldInvoke = true;
            }
            catch (SecurityException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
            if (!couldInvoke) {
                try {
                    m = clazz2.getMethod("run", String[].class);
                    m.invoke(bean, new Object[]{args2});
                    couldInvoke = true;
                }
                catch (SecurityException e) {
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {}
            }
        }
        catch (ClassNotFoundException e) {
            System.err.println("Cant find the class '" + classname + "' as specified in the system property '" + PARAMETER_NAME + "'.");
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.print(classname);
            if (classHasOptions) {
                System.err.print(" [options]");
            }
            if (classHasArgument) {
                System.err.print(" arguments");
            }
            System.err.println();
            if (parser != null) {
                parser.printUsage(System.err);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean hasAnnotation(Class clazz2, Class<? extends Annotation> annotation) {
        if (clazz2.getAnnotation(annotation) != null) {
            return true;
        }
        for (Field field2 : clazz2.getFields()) {
            if (field2.getAnnotation(annotation) == null) continue;
            return true;
        }
        for (AccessibleObject accessibleObject : clazz2.getMethods()) {
            if (((Method)accessibleObject).getAnnotation(annotation) == null) continue;
            return true;
        }
        return false;
    }
}

