/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j;

import java.lang.reflect.AccessibleObject;
import java.net.URL;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Config;
import org.kohsuke.args4j.Messages;
import org.kohsuke.args4j.spi.ArgumentImpl;
import org.kohsuke.args4j.spi.ConfigElement;
import org.kohsuke.args4j.spi.OptionImpl;
import org.kohsuke.args4j.spi.Setters;
import org.xml.sax.InputSource;

public class XmlParser {
    public void parse(URL xml, CmdLineParser parser, Object bean) {
        this.parse(new InputSource(xml.toExternalForm()), parser, bean);
    }

    public void parse(InputSource xml, CmdLineParser parser, Object bean) {
        try {
            Config config = Config.parse(xml);
            for (ConfigElement ce : config.options) {
                OptionImpl option = new OptionImpl(ce);
                parser.addOption(Setters.create(parser, this.findMethodOrField(bean, ce.field, ce.method), bean), option);
            }
            for (ConfigElement ce : config.arguments) {
                ArgumentImpl argument = new ArgumentImpl(ce);
                parser.addArgument(Setters.create(parser, this.findMethodOrField(bean, ce.field, ce.method), bean), argument);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.METADATA_ERROR.format(new Object[0]), e);
        }
    }

    private AccessibleObject findMethodOrField(Object bean, String field2, String method) throws SecurityException, NoSuchFieldException, NoSuchMethodException, ClassNotFoundException {
        AccessibleObject rv;
        if (field2 != null) {
            rv = bean.getClass().getDeclaredField(field2);
        } else {
            String methodName = method.substring(0, method.indexOf("("));
            String[] params2 = method.substring(method.indexOf("(") + 1, method.indexOf(")")).split(",");
            Class[] paramTypes2 = new Class[params2.length];
            for (int i = 0; i < params2.length; ++i) {
                String className = params2[i];
                if (className.indexOf(46) < 0) {
                    className = "java.lang." + className;
                }
                paramTypes2[i] = Class.forName(className);
            }
            rv = bean.getClass().getMethod(methodName, paramTypes2);
        }
        return rv;
    }
}

