/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.spi;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import org.kohsuke.args4j.IllegalAnnotationError;
import org.kohsuke.args4j.spi.FieldSetter;
import org.kohsuke.args4j.spi.Messages;
import org.kohsuke.args4j.spi.Setter;

final class ArrayFieldSetter
implements Setter {
    private final Object bean;
    private final Field f;
    private Object defaultArray;

    public ArrayFieldSetter(Object bean, Field f2) {
        this.bean = bean;
        this.f = f2;
        if (!f2.getType().isArray()) {
            throw new IllegalAnnotationError(Messages.ILLEGAL_FIELD_SIGNATURE.format(f2.getType()));
        }
        this.trySetDefault(bean);
    }

    private void trySetDefault(Object bean1) throws IllegalAccessError {
        try {
            this.doSetDefault(bean1);
        }
        catch (IllegalAccessException ex) {
            try {
                this.f.setAccessible(true);
                this.doSetDefault(bean1);
            }
            catch (IllegalAccessException ex1) {
                throw new IllegalAccessError(ex1.getMessage());
            }
        }
    }

    private void doSetDefault(Object bean) throws IllegalAccessException {
        this.defaultArray = this.f.get(bean);
    }

    public FieldSetter asFieldSetter() {
        return new FieldSetter(this.bean, this.f);
    }

    public AnnotatedElement asAnnotatedElement() {
        return this.f;
    }

    public boolean isMultiValued() {
        return true;
    }

    public Class getType() {
        return this.f.getType().getComponentType();
    }

    public void addValue(Object value2) {
        try {
            this.doAddValue(this.bean, value2);
        }
        catch (IllegalAccessException ex) {
            this.f.setAccessible(true);
            try {
                this.doAddValue(this.bean, value2);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
        }
    }

    private void doAddValue(Object bean, Object value2) throws IllegalAccessException {
        Object ary = this.f.get(bean);
        if (ary == null || ary == this.defaultArray) {
            ary = Array.newInstance(this.getType(), 1);
            Array.set(ary, 0, value2);
        } else {
            int len = Array.getLength(ary);
            Object newAry = Array.newInstance(ary.getClass().getComponentType(), len + 1);
            System.arraycopy(ary, 0, newAry, 0, len);
            Array.set(newAry, len, value2);
            ary = newAry;
        }
        this.f.set(bean, ary);
    }
}

