/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.spi;

import java.util.ResourceBundle;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.Messages;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumOptionHandler<T extends Enum<T>>
extends OptionHandler<T> {
    private final Class<T> enumType;

    public EnumOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super T> setter2, Class<T> enumType) {
        super(parser, option, setter2);
        this.enumType = enumType;
    }

    @Override
    public int parseArguments(Parameters params2) throws CmdLineException {
        String s2 = params2.getParameter(0).replaceAll("-", "_");
        Enum value2 = null;
        for (Enum o : (Enum[])this.enumType.getEnumConstants()) {
            if (!o.name().equalsIgnoreCase(s2)) continue;
            value2 = o;
            break;
        }
        if (value2 == null) {
            if (this.option.isArgument()) {
                throw new CmdLineException(this.owner, Messages.ILLEGAL_OPERAND, this.option.toString(), s2);
            }
            throw new CmdLineException(this.owner, Messages.ILLEGAL_OPERAND, params2.getParameter(-1), s2);
        }
        this.setter.addValue(value2);
        return 1;
    }

    @Override
    public String getDefaultMetaVariable() {
        StringBuffer rv = new StringBuffer();
        rv.append("[");
        for (Enum t : (Enum[])this.enumType.getEnumConstants()) {
            rv.append(t).append(" | ");
        }
        rv.delete(rv.length() - 3, rv.length());
        rv.append("]");
        return rv.toString();
    }

    @Override
    public String getMetaVariable(ResourceBundle rb) {
        return this.getDefaultMetaVariable();
    }
}

