/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.spi;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.Messages;
import org.kohsuke.args4j.spi.OneArgumentOptionHandler;
import org.kohsuke.args4j.spi.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InetAddressOptionHandler
extends OneArgumentOptionHandler<InetAddress> {
    public InetAddressOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super InetAddress> setter2) {
        super(parser, option, setter2);
    }

    @Override
    protected InetAddress parse(String argument) throws CmdLineException {
        try {
            return InetAddress.getByName(argument);
        }
        catch (UnknownHostException e) {
            throw new CmdLineException(this.owner, Messages.ILLEGAL_IP_ADDRESS, argument);
        }
    }

    @Override
    public String getDefaultMetaVariable() {
        return Messages.DEFAULT_META_INET_ADDRESS_OPTION_HANDLER.format(new Object[0]);
    }
}

