/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.spi;

import java.util.ResourceBundle;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.ParserProperties;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OptionHandler<T> {
    public final OptionDef option;
    public final Setter<? super T> setter;
    public final CmdLineParser owner;

    protected OptionHandler(CmdLineParser parser, OptionDef option, Setter<? super T> setter2) {
        this.owner = parser;
        this.option = option;
        this.setter = setter2;
    }

    public abstract int parseArguments(Parameters var1) throws CmdLineException;

    public abstract String getDefaultMetaVariable();

    public String getMetaVariable(ResourceBundle rb) {
        String localized;
        String token2 = this.option.metaVar();
        if (token2.length() == 0) {
            token2 = this.getDefaultMetaVariable();
        }
        if (token2 == null) {
            return null;
        }
        if (rb != null && (localized = rb.getString(token2)) != null) {
            token2 = localized;
        }
        return token2;
    }

    public final String getNameAndMeta(ResourceBundle rb) {
        return this.getNameAndMeta(rb, ParserProperties.defaults());
    }

    public final String getNameAndMeta(ResourceBundle rb, ParserProperties properties) {
        String str = this.option.isArgument() ? "" : this.option.toString();
        String meta = this.getMetaVariable(rb);
        if (meta != null) {
            if (str.length() > 0) {
                str = str + properties.getOptionValueDelimiter();
            }
            str = str + meta;
        }
        return str;
    }
}

