/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.spi;

import java.util.AbstractList;
import java.util.Collection;
import java.util.ResourceBundle;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.Messages;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;
import org.kohsuke.args4j.spi.SubCommand;
import org.kohsuke.args4j.spi.SubCommands;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubCommandHandler
extends OptionHandler<Object> {
    private final SubCommands commands;

    public SubCommandHandler(CmdLineParser parser, OptionDef option, Setter<Object> setter2) {
        super(parser, option, setter2);
        this.commands = setter2.asAnnotatedElement().getAnnotation(SubCommands.class);
        if (this.commands == null) {
            throw new IllegalStateException("SubCommandHandler must be used with @SubCommands annotation");
        }
    }

    @Override
    public int parseArguments(Parameters params2) throws CmdLineException {
        String subCmd = params2.getParameter(0);
        for (SubCommand c : this.commands.value()) {
            if (!c.name().equals(subCmd)) continue;
            this.setter.addValue(this.subCommand(c, params2));
            return params2.size();
        }
        return this.fallback(subCmd);
    }

    protected int fallback(String subCmd) throws CmdLineException {
        throw new CmdLineException(this.owner, Messages.ILLEGAL_OPERAND, this.option.toString(), subCmd);
    }

    protected Object subCommand(SubCommand c, final Parameters params2) throws CmdLineException {
        Object subCmd = this.instantiate(c);
        CmdLineParser p = this.configureParser(subCmd, c);
        p.parseArgument((Collection<String>)new AbstractList<String>(){

            @Override
            public String get(int index2) {
                try {
                    return params2.getParameter(index2 + 1);
                }
                catch (CmdLineException e) {
                    throw new IndexOutOfBoundsException();
                }
            }

            @Override
            public int size() {
                return params2.size() - 1;
            }
        });
        return subCmd;
    }

    protected CmdLineParser configureParser(Object subCmd, SubCommand c) {
        return new CmdLineParser(subCmd);
    }

    protected Object instantiate(SubCommand c) {
        try {
            return c.impl().newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Failed to instantiate " + c, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to instantiate " + c, e);
        }
    }

    @Override
    public String getDefaultMetaVariable() {
        StringBuffer rv = new StringBuffer();
        rv.append("[");
        for (SubCommand sc : this.commands.value()) {
            rv.append(sc.name()).append(" | ");
        }
        rv.delete(rv.length() - 3, rv.length());
        rv.append("]");
        return rv.toString();
    }

    @Override
    public String getMetaVariable(ResourceBundle rb) {
        return this.getDefaultMetaVariable();
    }
}

