/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.javascript;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.myfaces.trinidadbuild.plugin.javascript.uixtools.Reducer;

public class ReduceJavascriptMojo
extends AbstractMojo {
    private MavenProject project;
    private File sourceDirectory;
    private String sourcePath;
    private File targetDirectory;
    private String targetPath;
    private String optimizeTargetPath;

    public void execute() throws MojoExecutionException {
        ArrayList<File> compileSourceRoots = new ArrayList<File>();
        compileSourceRoots.add(this.sourceDirectory);
        compileSourceRoots.add(new File(this.project.getBuild().getDirectory(), "maven-i18n-plugin/main/javascript"));
        compileSourceRoots.add(new File(this.project.getBuild().getDirectory(), "maven-faces-plugin/main/javascript"));
        try {
            Resource resource = new Resource();
            resource.setDirectory(this.targetDirectory.getCanonicalPath());
            this.project.addResource(resource);
            File outputDirectory = new File(this.targetDirectory, this.targetPath);
            outputDirectory.mkdirs();
            for (File sourceRoot : compileSourceRoots) {
                File sourceDirectory = new File(sourceRoot, this.sourcePath);
                if (!sourceDirectory.exists()) continue;
                Collection jsFiles = FileUtils.listFiles((File)sourceDirectory, (String[])new String[]{"js"}, (boolean)false);
                for (File jsFile : jsFiles) {
                    FileUtils.copyFileToDirectory((File)jsFile, (File)outputDirectory);
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying Javascript files", (Exception)e);
        }
        try {
            if (this.optimizeTargetPath != null) {
                File outputDirectory = new File(this.targetDirectory, this.optimizeTargetPath);
                outputDirectory.mkdirs();
                for (File sourceRoot : compileSourceRoots) {
                    File sourceDirectory = new File(sourceRoot, this.sourcePath);
                    if (!sourceDirectory.exists()) continue;
                    String[] args = new String[]{sourceDirectory.getCanonicalPath(), outputDirectory.getCanonicalPath()};
                    Reducer.main(args);
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error compiling Javascript files", (Exception)e);
        }
    }
}

