/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.javascript.uixtools;

import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import org.apache.myfaces.trinidadbuild.plugin.javascript.uixtools.Token;
import org.apache.myfaces.trinidadbuild.plugin.javascript.uixtools.TokenBuffer;
import org.apache.myfaces.trinidadbuild.plugin.javascript.uixtools.TokenException;
import org.apache.myfaces.trinidadbuild.plugin.javascript.uixtools.TokenReader;

public class Filter2
implements TokenReader {
    private int _state = 0;
    private int _openCurly = 0;
    private int _beginFunction = 0;
    private boolean _isFunctionUsingEval = false;
    private final TokenReader _in;
    private final NameGen _nameGen = new NameGen();
    private final HashMap _localVarMap = new HashMap();
    private final TokenBuffer _buffer = new TokenBuffer();
    private final Vector _function = new Vector();
    private static final int ROOT_MODE = 0;
    private static final int FUNCTION_MODE = 1;
    private static final int FUNCTION_PARAM_MODE = 2;
    private static final int FUNCTION_BODY_MODE = 3;
    private static final int VAR_DEF_MODE = 4;
    private static final int PERIOD_MODE = 5;

    public Filter2(TokenReader in) {
        this._in = in;
        Runnable runner = new Runnable(){

            public void run() {
                try {
                    Filter2.this._run();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        new Thread(runner).start();
    }

    public Token read() throws IOException, InterruptedException {
        return this._buffer.read();
    }

    private void _run() throws InterruptedException {
        try {
            Token cur = this._in.read();
            while (cur != null) {
                this._process(cur);
                cur = this._in.read();
            }
        }
        catch (IOException e) {
            this._buffer.write(e);
        }
        catch (TokenException e) {
            e.printStackTrace();
            this._buffer.write(new IOException("Error parsing line:" + e.getToken().lineNumber));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this._buffer.write(new IOException());
        }
        this._buffer.close();
    }

    private void _process(Token cur) throws InterruptedException {
        if (cur.code == 110 && cur.ch == '{') {
            ++this._openCurly;
        } else if (cur.code == 120 && cur.ch == '}') {
            --this._openCurly;
        }
        switch (this._state) {
            case 0: {
                if (cur.code == 200 && cur.string.equals("function")) {
                    this._state = 2;
                    this._function.clear();
                    this._isFunctionUsingEval = false;
                    this._function.add(cur);
                    break;
                }
                this._buffer.write(cur);
                break;
            }
            case 2: {
                this._function.add(cur);
                if (cur.code != 110 || cur.ch != '{') break;
                this._state = 3;
                this._beginFunction = this._openCurly;
                break;
            }
            case 3: {
                this._function.add(cur);
                if (this._openCurly < this._beginFunction) {
                    this._state = 0;
                    if (this._isFunctionUsingEval) {
                        this._writeTokens(this._function);
                        break;
                    }
                    int sz = this._function.size();
                    for (int i = 0; i < sz; ++i) {
                        this._process2((Token)this._function.get(i));
                    }
                    break;
                }
                if (cur.code != 30 || !cur.string.equals("eval")) break;
                this._isFunctionUsingEval = true;
            }
        }
    }

    private void _process2(Token cur) throws InterruptedException {
        if (cur.code == 110 && cur.ch == '{') {
            ++this._openCurly;
        } else if (cur.code == 120 && cur.ch == '}') {
            --this._openCurly;
        }
        switch (this._state) {
            case 0: {
                if (cur.code != 200 || !cur.string.equals("function")) break;
                this._state = 1;
                break;
            }
            case 1: {
                if (cur.code == 110 && cur.ch == '(') {
                    this._state = 2;
                    this._localVarMap.clear();
                    break;
                }
                if (cur.code != 30) break;
                this._nameGen.reset();
                break;
            }
            case 2: {
                Token tok;
                if (cur.code == 110 && cur.ch == '{') {
                    this._state = 3;
                    this._beginFunction = this._openCurly;
                    break;
                }
                if (cur.code != 30) break;
                cur = tok = this._getNewToken(cur);
                break;
            }
            case 3: {
                if (this._openCurly < this._beginFunction) {
                    this._state = 0;
                    break;
                }
                if (cur.code == 12) {
                    this._state = 5;
                    break;
                }
                if (cur.code == 200 && cur.string.equals("var")) {
                    this._state = 4;
                    break;
                }
                if (cur.code != 30) break;
                cur = this._substForToken(cur);
                break;
            }
            case 4: {
                Token tok;
                if (cur.code != 30) break;
                this._state = 3;
                cur = tok = this._getNewToken(cur);
                break;
            }
            case 5: {
                this._state = 3;
            }
        }
        this._buffer.write(cur);
    }

    private void _writeTokens(Vector tokens) throws InterruptedException {
        int sz = tokens.size();
        for (int i = 0; i < sz; ++i) {
            this._buffer.write((Token)tokens.get(i));
        }
    }

    private Token _getNewToken(Token oldToken) {
        String oldName = oldToken.string;
        String newName = (String)this._localVarMap.get(oldName);
        if (newName == null) {
            newName = this._nameGen.getNext();
            this._localVarMap.put(oldName, newName);
        }
        return new Token(oldToken.code, oldToken.lineNumber, newName);
    }

    private Token _substForToken(Token oldToken) {
        String oldName = oldToken.string;
        String newName = (String)this._localVarMap.get(oldName);
        if (newName == null) {
            if (this._nameGen.isInUse(oldName)) {
                throw new TokenException(oldToken, "Conflict with global var:" + oldName);
            }
            return oldToken;
        }
        Token tok = new Token(oldToken.code, oldToken.lineNumber, newName);
        return tok;
    }

    private class NameGen {
        private int _i = 0;
        private char _ch = (char)97;
        private final StringBuffer _sb = new StringBuffer();

        private NameGen() {
        }

        public String getNext() {
            this._sb.setLength(0);
            return this._sb.append(this._ch).append(this._i++).toString();
        }

        public void reset() {
            this._i = 0;
        }

        public boolean isInUse(String varName) {
            int sz = varName.length();
            if (varName.charAt(0) != this._ch || sz <= 1) {
                return false;
            }
            for (int i = 1; i < sz; ++i) {
                if (Character.isDigit(varName.charAt(i))) continue;
                return false;
            }
            String ipart = varName.substring(1);
            int j = Integer.parseInt(ipart);
            return j < this._i;
        }
    }
}

