/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadbuild.plugin.javascript.uixtools;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.myfaces.trinidadbuild.plugin.javascript.uixtools.Token;

public class Detokenizer {
    private final PrintWriter _out;

    public Detokenizer(PrintWriter out) {
        this._out = out;
    }

    public Detokenizer(Writer out) {
        this(new PrintWriter(out));
    }

    public void write(Token tok) throws IOException {
        int com = tok.code;
        switch (com) {
            case 10: {
                this._out.println();
                break;
            }
            case 11: {
                this._out.print(' ');
                break;
            }
            case 12: {
                this._out.print('.');
                break;
            }
            case 13: {
                this._out.print(';');
                break;
            }
            case 20: {
                char ch = tok.ch;
                this._out.print(ch + tok.string + ch);
                break;
            }
            case 100: 
            case 110: 
            case 120: {
                this._out.print(tok.ch);
                break;
            }
            case 30: 
            case 40: 
            case 200: {
                this._out.print(tok.string);
                break;
            }
            case 50: {
                this._out.print("/*" + tok.string + "*/");
                break;
            }
            case 60: {
                this._out.print("/" + tok.string + "/");
                break;
            }
            case 65: {
                this._out.print(tok.ch);
                break;
            }
            case 0: {
                this._out.close();
                break;
            }
            default: {
                throw new RuntimeException("Unknown Token:" + tok);
            }
        }
    }
}

